/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.net.udp.handler.EventHandler;
import org.tron.common.net.udp.handler.UdpEvent;
import org.tron.common.net.udp.message.Message;
import org.tron.common.net.udp.message.discover.FindNodeMessage;
import org.tron.common.net.udp.message.discover.NeighborsMessage;
import org.tron.common.net.udp.message.discover.PingMessage;
import org.tron.common.net.udp.message.discover.PongMessage;
import org.tron.common.overlay.discover.DiscoverListener;
import org.tron.common.overlay.discover.RefreshTask;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeHandler;
import org.tron.common.overlay.discover.node.statistics.NodeStatistics;
import org.tron.common.overlay.discover.table.NodeTable;
import org.tron.common.utils.CollectionUtils;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;

@Component
public class NodeManager
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"NodeManager");
    private Args args = Args.getInstance();
    private Manager dbManager;
    private static final long LISTENER_REFRESH_RATE = 1000L;
    private static final long DB_COMMIT_RATE = 60000L;
    private static final int MAX_NODES = 2000;
    private static final int NODES_TRIM_THRESHOLD = 3000;
    private Consumer<UdpEvent> messageSender;
    private NodeTable table;
    private Node homeNode;
    private Map<String, NodeHandler> nodeHandlerMap = new ConcurrentHashMap<String, NodeHandler>();
    private List<Node> bootNodes = new ArrayList<Node>();
    private boolean inboundOnlyFromKnownNodes = false;
    private boolean discoveryEnabled;
    private Map<DiscoverListener, ListenerHandler> listeners = new IdentityHashMap<DiscoverListener, ListenerHandler>();
    private boolean inited = false;
    private Timer logStatsTimer = new Timer();
    private Timer nodeManagerTasksTimer = new Timer("NodeManagerTasks");
    private ScheduledExecutorService pongTimer;

    @Autowired
    public NodeManager(Manager dbManager) {
        this.dbManager = dbManager;
        this.discoveryEnabled = this.args.isNodeDiscoveryEnable();
        this.homeNode = new Node(RefreshTask.getNodeId(), this.args.getNodeExternalIp(), this.args.getNodeListenPort());
        for (String boot : this.args.getSeedNode().getIpList()) {
            this.bootNodes.add(Node.instanceOf(boot));
        }
        logger.info("homeNode : {}", (Object)this.homeNode);
        logger.info("bootNodes : size= {}", (Object)this.bootNodes.size());
        this.table = new NodeTable(this.homeNode);
        this.logStatsTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                logger.trace("Statistics:\n {}", (Object)NodeManager.this.dumpAllStatistics());
            }
        }, 1000L, 60000L);
        this.pongTimer = Executors.newSingleThreadScheduledExecutor();
    }

    public ScheduledExecutorService getPongTimer() {
        return this.pongTimer;
    }

    @Override
    public void channelActivated() {
        if (!this.inited) {
            this.inited = true;
            this.nodeManagerTasksTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    NodeManager.this.processListeners();
                }
            }, 1000L, 1000L);
            if (this.args.isNodeDiscoveryPersist()) {
                this.dbRead();
                this.nodeManagerTasksTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        NodeManager.this.dbWrite();
                    }
                }, 60000L, 60000L);
            }
            for (Node node : this.bootNodes) {
                this.getNodeHandler(node);
            }
        }
    }

    public boolean isNodeAlive(NodeHandler nodeHandler) {
        return nodeHandler.getState().equals((Object)NodeHandler.State.Alive) || nodeHandler.getState().equals((Object)NodeHandler.State.Active) || nodeHandler.getState().equals((Object)NodeHandler.State.EvictCandidate);
    }

    private void dbRead() {
        Set<Node> nodes = this.dbManager.readNeighbours();
        logger.info("Reading Node statistics from PeersStore: " + nodes.size() + " nodes.");
        nodes.forEach(node -> this.getNodeHandler((Node)node).getNodeStatistics().setPersistedReputation(node.getReputation()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbWrite() {
        HashSet<Node> batch = new HashSet<Node>();
        NodeManager nodeManager = this;
        synchronized (nodeManager) {
            for (NodeHandler nodeHandler : this.nodeHandlerMap.values()) {
                int reputation = nodeHandler.getNodeStatistics().getReputation();
                nodeHandler.getNode().setReputation(reputation);
                batch.add(nodeHandler.getNode());
            }
        }
        logger.info("Write Node statistics to PeersStore: " + batch.size() + " nodes.");
        this.dbManager.clearAndWriteNeighbours(batch);
    }

    public void setMessageSender(Consumer<UdpEvent> messageSender) {
        this.messageSender = messageSender;
    }

    private String getKey(Node n) {
        return this.getKey(new InetSocketAddress(n.getHost(), n.getPort()));
    }

    private String getKey(InetSocketAddress address) {
        InetAddress addr = address.getAddress();
        return (addr == null ? address.getHostString() : addr.getHostAddress()) + ":" + address.getPort();
    }

    public synchronized NodeHandler getNodeHandler(Node n) {
        String key = this.getKey(n);
        NodeHandler ret = this.nodeHandlerMap.get(key);
        if (ret == null) {
            this.trimTable();
            ret = new NodeHandler(n, this);
            this.nodeHandlerMap.put(key, ret);
        } else if (ret.getNode().isDiscoveryNode() && !n.isDiscoveryNode()) {
            ret.setNode(n);
        }
        return ret;
    }

    private void trimTable() {
        if (this.nodeHandlerMap.size() > 3000) {
            ArrayList<NodeHandler> sorted = new ArrayList<NodeHandler>(this.nodeHandlerMap.values());
            sorted.sort(Comparator.comparingInt(o -> o.getNodeStatistics().getReputation()));
            for (NodeHandler handler : sorted) {
                this.nodeHandlerMap.values().remove(handler);
                if (this.nodeHandlerMap.size() > 2000) continue;
                break;
            }
        }
    }

    public boolean hasNodeHandler(Node n) {
        return this.nodeHandlerMap.containsKey(this.getKey(n));
    }

    public NodeTable getTable() {
        return this.table;
    }

    public NodeStatistics getNodeStatistics(Node n) {
        return this.getNodeHandler(n).getNodeStatistics();
    }

    @Override
    public void handleEvent(UdpEvent udpEvent) {
        Message m = udpEvent.getMessage();
        InetSocketAddress sender = udpEvent.getAddress();
        Node n = new Node(m.getFrom().getId(), sender.getHostString(), sender.getPort());
        if (this.inboundOnlyFromKnownNodes && !this.hasNodeHandler(n)) {
            logger.warn("Receive packet from unknown node {}.", (Object)sender.getAddress());
            return;
        }
        NodeHandler nodeHandler = this.getNodeHandler(n);
        nodeHandler.getNodeStatistics().messageStatistics.addUdpInMessage(m.getType());
        switch (m.getType()) {
            case DISCOVER_PING: {
                nodeHandler.handlePing((PingMessage)m);
                break;
            }
            case DISCOVER_PONG: {
                nodeHandler.handlePong((PongMessage)m);
                break;
            }
            case DISCOVER_FIND_NODE: {
                nodeHandler.handleFindNode((FindNodeMessage)m);
                break;
            }
            case DISCOVER_NEIGHBORS: {
                nodeHandler.handleNeighbours((NeighborsMessage)m);
                break;
            }
        }
    }

    public void sendOutbound(UdpEvent udpEvent) {
        if (this.discoveryEnabled && this.messageSender != null) {
            this.messageSender.accept(udpEvent);
        }
    }

    public synchronized List<NodeHandler> getNodes(int minReputation) {
        ArrayList<NodeHandler> ret = new ArrayList<NodeHandler>();
        for (NodeHandler nodeHandler : this.nodeHandlerMap.values()) {
            if (nodeHandler.getNodeStatistics().getReputation() < minReputation) continue;
            ret.add(nodeHandler);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeHandler> getNodes(Predicate<NodeHandler> predicate, int limit) {
        ArrayList<NodeHandler> filtered = new ArrayList<NodeHandler>();
        NodeManager nodeManager = this;
        synchronized (nodeManager) {
            for (NodeHandler handler : this.nodeHandlerMap.values()) {
                if (!predicate.test(handler)) continue;
                filtered.add(handler);
            }
        }
        logger.debug("nodeHandlerMap size {} filter peer  size {}", (Object)this.nodeHandlerMap.size(), (Object)filtered.size());
        filtered.sort(Comparator.comparingInt(o -> o.getNodeStatistics().getReputation()).reversed());
        return CollectionUtils.truncate(filtered, limit);
    }

    public List<NodeHandler> dumpActiveNodes() {
        ArrayList<NodeHandler> handlers = new ArrayList<NodeHandler>();
        for (NodeHandler handler : this.nodeHandlerMap.values()) {
            if (!this.isNodeAlive(handler)) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    private synchronized void processListeners() {
        for (ListenerHandler handler : this.listeners.values()) {
            try {
                handler.checkAll();
            }
            catch (Exception e) {
                logger.error("Exception processing listener: " + handler, (Throwable)e);
            }
        }
    }

    public synchronized void addDiscoverListener(DiscoverListener listener, Predicate<NodeStatistics> filter) {
        this.listeners.put(listener, new ListenerHandler(listener, filter));
    }

    public synchronized String dumpAllStatistics() {
        ArrayList<NodeHandler> l = new ArrayList<NodeHandler>(this.nodeHandlerMap.values());
        l.sort(Comparator.comparingInt(o -> o.getNodeStatistics().getReputation()).reversed());
        StringBuilder sb = new StringBuilder();
        int zeroReputCount = 0;
        for (NodeHandler nodeHandler : l) {
            if (nodeHandler.getNodeStatistics().getReputation() > 0) {
                sb.append(nodeHandler).append("\t").append(nodeHandler.getNodeStatistics()).append("\n");
                continue;
            }
            ++zeroReputCount;
        }
        sb.append("0 reputation: ").append(zeroReputCount).append(" nodes.\n");
        return sb.toString();
    }

    public Node getPublicHomeNode() {
        return this.homeNode;
    }

    public void close() {
        try {
            this.nodeManagerTasksTimer.cancel();
            this.pongTimer.shutdownNow();
            this.logStatsTimer.cancel();
        }
        catch (Exception e) {
            logger.warn("close failed.", (Throwable)e);
        }
    }

    private class ListenerHandler {
        private Map<NodeHandler, Object> discoveredNodes = new IdentityHashMap<NodeHandler, Object>();
        private DiscoverListener listener;
        private Predicate<NodeStatistics> filter;

        ListenerHandler(DiscoverListener listener, Predicate<NodeStatistics> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        void checkAll() {
            for (NodeHandler handler : NodeManager.this.nodeHandlerMap.values()) {
                boolean has = this.discoveredNodes.containsKey(handler);
                boolean test = this.filter.test(handler.getNodeStatistics());
                if (!has && test) {
                    this.listener.nodeAppeared(handler);
                    this.discoveredNodes.put(handler, null);
                    continue;
                }
                if (!has || test) continue;
                this.listener.nodeDisappeared(handler);
                this.discoveredNodes.remove(handler);
            }
        }
    }
}

