/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.dht;

import java.math.BigInteger;
import org.spongycastle.util.BigIntegers;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.utils.Utils;

public class Peer {
    byte[] id;
    String host = "127.0.0.1";
    int port = 0;

    public Peer(byte[] id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    public Peer(byte[] ip) {
        this.id = ip;
    }

    public byte nextBit(String startPattern) {
        if (this.toBinaryString().startsWith(startPattern + "1")) {
            return 1;
        }
        return 0;
    }

    public byte[] calcDistance(Peer toPeer) {
        BigInteger aaPeer = new BigInteger(this.getId());
        BigInteger bbPeer = new BigInteger(toPeer.getId());
        BigInteger distance = aaPeer.xor(bbPeer);
        return BigIntegers.asUnsignedByteArray((BigInteger)distance);
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        this.id = id;
    }

    public String toString() {
        return String.format("Peer {\n id=%s, \n host=%s, \n port=%d\n}", Hex.toHexString((byte[])this.id), this.host, this.port);
    }

    public String toBinaryString() {
        BigInteger bi = new BigInteger(1, this.id);
        String out = String.format("%512s", bi.toString(2));
        out = out.replace(' ', '0');
        return out;
    }

    public static byte[] randomPeerId() {
        byte[] peerIdBytes = new BigInteger(512, Utils.getRandom()).toByteArray();
        String peerId = peerIdBytes.length > 64 ? Hex.toHexString((byte[])peerIdBytes, (int)1, (int)64) : Hex.toHexString((byte[])peerIdBytes);
        return Hex.decode((String)peerId);
    }
}

