/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.net.udp.handler.MessageHandler;
import org.tron.common.net.udp.handler.PacketDecoder;
import org.tron.common.overlay.discover.DiscoveryExecutor;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.server.WireTrafficStats;
import org.tron.core.config.args.Args;

@Component
public class DiscoverServer {
    private static final Logger logger = LoggerFactory.getLogger((String)"DiscoverServer");
    @Autowired
    private NodeManager nodeManager;
    @Autowired
    private WireTrafficStats stats;
    private Args args = Args.getInstance();
    private int port = this.args.getNodeListenPort();
    private Channel channel;
    private DiscoveryExecutor discoveryExecutor;
    private volatile boolean shutdown = false;

    @Autowired
    public DiscoverServer(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
        if (this.args.isNodeDiscoveryEnable()) {
            if (this.port == 0) {
                logger.error("Discovery can't be started while listen port == 0");
            } else {
                new Thread(() -> {
                    try {
                        this.start();
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }, "DiscoverServer").start();
            }
        }
    }

    public void start() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(this.args.getUdpNettyWorkThreadNum());
        try {
            this.discoveryExecutor = new DiscoveryExecutor(this.nodeManager);
            this.discoveryExecutor.start();
            while (!this.shutdown) {
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

                    public void initChannel(NioDatagramChannel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{((DiscoverServer)DiscoverServer.this).stats.udp});
                        ch.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
                        ch.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
                        ch.pipeline().addLast(new ChannelHandler[]{new PacketDecoder()});
                        MessageHandler messageHandler = new MessageHandler(ch, DiscoverServer.this.nodeManager);
                        DiscoverServer.this.nodeManager.setMessageSender(messageHandler);
                        ch.pipeline().addLast(new ChannelHandler[]{messageHandler});
                    }
                });
                this.channel = b.bind(this.port).sync().channel();
                logger.info("Discovery server started, bind port {}", (Object)this.port);
                this.channel.closeFuture().sync();
                if (this.shutdown) {
                    logger.info("Shutdown discovery server");
                    break;
                }
                logger.warn(" Restart discovery server after 5 sec pause...");
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            logger.error("Start discovery server with port {} failed.", (Object)this.port, (Object)e);
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    public void close() {
        logger.info("Closing discovery server...");
        this.shutdown = true;
        if (this.channel != null) {
            try {
                this.channel.close().await(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.info("Closing discovery server failed.", (Throwable)e);
            }
        }
        if (this.discoveryExecutor != null) {
            try {
                this.discoveryExecutor.close();
            }
            catch (Exception e) {
                logger.info("Closing discovery executor failed.", (Throwable)e);
            }
        }
    }
}

