/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeHandler;
import org.tron.common.overlay.server.TronChannelInitializer;
import org.tron.core.config.args.Args;
import org.tron.core.net.node.NodeImpl;
import org.tron.protos.Protocol;

@Component
public class PeerClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"PeerClient");
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    @Lazy
    private NodeImpl node;
    private EventLoopGroup workerGroup = new NioEventLoopGroup(0, new ThreadFactory(){
        AtomicInteger cnt = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "TronJClientWorker-" + this.cnt.getAndIncrement());
        }
    });

    public void connect(String host, int port, String remoteId) {
        try {
            ChannelFuture f = this.connectAsync(host, port, remoteId, false);
            f.sync().channel().closeFuture().sync();
        }
        catch (Exception e) {
            logger.info("PeerClient: Can't connect to " + host + ":" + port + " (" + e.getMessage() + ")");
        }
    }

    public ChannelFuture connectAsync(NodeHandler nodeHandler, boolean discoveryMode) {
        Node node = nodeHandler.getNode();
        return this.connectAsync(node.getHost(), node.getPort(), node.getHexId(), discoveryMode).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                logger.error("connect to {}:{} fail,cause:{}", new Object[]{node.getHost(), node.getPort(), future.cause().getMessage()});
                nodeHandler.getNodeStatistics().nodeDisconnectedLocal(Protocol.ReasonCode.CONNECT_FAIL);
                nodeHandler.getNodeStatistics().notifyDisconnect();
                future.channel().close();
            }
        }));
    }

    public ChannelFuture connectAsync(String host, int port, String remoteId, boolean discoveryMode) {
        logger.info("connect peer {} {} {}", new Object[]{host, port, remoteId});
        TronChannelInitializer tronChannelInitializer = (TronChannelInitializer)((Object)this.ctx.getBean(TronChannelInitializer.class, new Object[]{remoteId}));
        tronChannelInitializer.setPeerDiscoveryMode(discoveryMode);
        tronChannelInitializer.setNodeImpl(this.node);
        Bootstrap b = new Bootstrap();
        b.group(this.workerGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)DefaultMessageSizeEstimator.DEFAULT);
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Args.getInstance().getNodeConnectionTimeout());
        b.remoteAddress(host, port);
        b.handler((ChannelHandler)tronChannelInitializer);
        return b.connect();
    }

    public void close() {
        this.workerGroup.shutdownGracefully();
        this.workerGroup.terminationFuture().syncUninterruptibly();
    }
}

