/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.net.udp.message.discover;

import com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.net.udp.message.Message;
import org.tron.common.net.udp.message.UdpMessageTypeEnum;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.utils.ByteArray;
import org.tron.core.config.args.Args;
import org.tron.protos.Discover;

public class PongMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(PongMessage.class);
    private Discover.PongMessage pongMessage;

    public PongMessage(byte[] data) throws Exception {
        super(UdpMessageTypeEnum.DISCOVER_PONG, data);
        this.pongMessage = Discover.PongMessage.parseFrom(data);
    }

    public PongMessage(Node from) {
        super(UdpMessageTypeEnum.DISCOVER_PONG, null);
        Discover.Endpoint toEndpoint = Discover.Endpoint.newBuilder().setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(from.getHost()))).setPort(from.getPort()).setNodeId(ByteString.copyFrom((byte[])from.getId())).build();
        this.pongMessage = Discover.PongMessage.newBuilder().setFrom(toEndpoint).setEcho(Args.getInstance().getNodeP2pVersion()).setTimestamp(System.currentTimeMillis()).build();
        this.data = this.pongMessage.toByteArray();
    }

    public int getVersion() {
        return this.pongMessage.getEcho();
    }

    @Override
    public Node getFrom() {
        return Message.getNode(this.pongMessage.getFrom());
    }

    @Override
    public String toString() {
        return "[pongMessage: " + this.pongMessage;
    }
}

