/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.zksnark;

import java.math.BigInteger;
import org.tron.common.crypto.zksnark.Field;
import org.tron.common.crypto.zksnark.Fp;

class Fp2
implements Field<Fp2> {
    static final Fp2 ZERO = new Fp2(Fp.ZERO, Fp.ZERO);
    static final Fp2 _1 = new Fp2(Fp._1, Fp.ZERO);
    static final Fp2 NON_RESIDUE = new Fp2(BigInteger.valueOf(9L), BigInteger.ONE);
    static final Fp[] FROBENIUS_COEFFS_B = new Fp[]{new Fp(BigInteger.ONE), new Fp(new BigInteger("21888242871839275222246405745257275088696311157297823662689037894645226208582"))};
    Fp a;
    Fp b;

    Fp2(Fp a, Fp b) {
        this.a = a;
        this.b = b;
    }

    Fp2(BigInteger a, BigInteger b) {
        this(new Fp(a), new Fp(b));
    }

    @Override
    public Fp2 squared() {
        Fp ab = this.a.mul(this.b);
        Fp ra = this.a.add(this.b).mul(this.b.mul(Fp.NON_RESIDUE).add(this.a)).sub(ab).sub(ab.mul(Fp.NON_RESIDUE));
        Fp rb = ab.dbl();
        return new Fp2(ra, rb);
    }

    @Override
    public Fp2 mul(Fp2 o) {
        Fp aa = this.a.mul(o.a);
        Fp bb = this.b.mul(o.b);
        Fp ra = bb.mul(Fp.NON_RESIDUE).add(aa);
        Fp rb = this.a.add(this.b).mul(o.a.add(o.b)).sub(aa).sub(bb);
        return new Fp2(ra, rb);
    }

    @Override
    public Fp2 add(Fp2 o) {
        return new Fp2(this.a.add(o.a), this.b.add(o.b));
    }

    @Override
    public Fp2 sub(Fp2 o) {
        return new Fp2(this.a.sub(o.a), this.b.sub(o.b));
    }

    @Override
    public Fp2 dbl() {
        return this.add(this);
    }

    @Override
    public Fp2 inverse() {
        Fp t0 = this.a.squared();
        Fp t1 = this.b.squared();
        Fp t2 = t0.sub(Fp.NON_RESIDUE.mul(t1));
        Fp t3 = t2.inverse();
        Fp ra = this.a.mul(t3);
        Fp rb = this.b.mul(t3).negate();
        return new Fp2(ra, rb);
    }

    @Override
    public Fp2 negate() {
        return new Fp2(this.a.negate(), this.b.negate());
    }

    @Override
    public boolean isZero() {
        return this.equals(ZERO);
    }

    @Override
    public boolean isValid() {
        return this.a.isValid() && this.b.isValid();
    }

    static Fp2 create(BigInteger aa, BigInteger bb) {
        Fp a = Fp.create(aa);
        Fp b = Fp.create(bb);
        return new Fp2(a, b);
    }

    static Fp2 create(byte[] aa, byte[] bb) {
        Fp a = Fp.create(aa);
        Fp b = Fp.create(bb);
        return new Fp2(a, b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fp2 fp2 = (Fp2)o;
        if (this.a != null ? !this.a.equals(fp2.a) : fp2.a != null) {
            return false;
        }
        return !(this.b == null ? fp2.b != null : !this.b.equals(fp2.b));
    }

    public int hashCode() {
        return new Integer(this.a.hashCode() + this.b.hashCode()).hashCode();
    }

    Fp2 frobeniusMap(int power) {
        Fp ra = this.a;
        Fp rb = FROBENIUS_COEFFS_B[power % 2].mul(this.b);
        return new Fp2(ra, rb);
    }

    Fp2 mulByNonResidue() {
        return NON_RESIDUE.mul(this);
    }

    public String toString() {
        return String.format("%si + %s", this.a.toString(), this.b.toString());
    }
}

