/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.play.tasks;

import com.github.triplet.gradle.androidpublisher.EditResponse;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.common.utils.IoKt;
import com.github.triplet.gradle.play.PlayPublisherExtension;
import com.github.triplet.gradle.play.tasks.internal.EditTaskBase;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001\u0007B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/github/triplet/gradle/play/tasks/GenerateEdit;", "Lcom/github/triplet/gradle/play/tasks/internal/EditTaskBase;", "extension", "Lcom/github/triplet/gradle/play/PlayPublisherExtension;", "(Lcom/github/triplet/gradle/play/PlayPublisherExtension;)V", "generate", "", "Generator", "plugin"})
public abstract class GenerateEdit
extends EditTaskBase {
    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generate() {
        void workActionClass$iv;
        void $this$submit$iv;
        RegularFileProperty editId2 = this.getEditIdFile();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project $this$serviceOf$iv = project;
        boolean $i$f$serviceOf22 = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkExpressionValueIsNotNull((Object)serviceRegistry, (String)"(this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(WorkerExecutor.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        WorkQueue workQueue = ((WorkerExecutor)object).noIsolation();
        Intrinsics.checkExpressionValueIsNotNull((Object)workQueue, (String)"project.serviceOf<WorkerExecutor>().noIsolation()");
        $this$serviceOf$iv = workQueue;
        Class<Generator> $i$f$serviceOf22 = Generator.class;
        Action parameterAction$iv = new Action<T>(this, editId2){
            final /* synthetic */ GenerateEdit this$0;
            final /* synthetic */ RegularFileProperty $editId;

            public final void execute(@NotNull Generator.Params $this$submit) {
                Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                $this$submit.getConfig().set((Object)this.this$0.getExtension().getSerializableConfig$plugin());
                $this$submit.getEditIdFile().set((Provider)this.$editId);
            }
            {
                this.this$0 = generateEdit;
                this.$editId = regularFileProperty;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
    }

    @Inject
    public GenerateEdit(@NotNull PlayPublisherExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        super(extension);
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/triplet/gradle/play/tasks/GenerateEdit$Generator;", "Lorg/gradle/workers/WorkAction;", "Lcom/github/triplet/gradle/play/tasks/GenerateEdit$Generator$Params;", "fileOps", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/file/FileSystemOperations;)V", "appId", "", "file", "Ljava/io/File;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "execute", "", "getOrCreateEditId", "handleFailure", "response", "Lcom/github/triplet/gradle/androidpublisher/EditResponse$Failure;", "Params", "plugin"})
    public static abstract class Generator
    implements WorkAction<Params> {
        private final File file;
        private final String appId;
        private final PlayPublisher publisher;
        private final FileSystemOperations fileOps;

        public void execute() {
            FilesKt.writeText$default((File)IoKt.safeCreateNewFile(this.file), (String)this.getOrCreateEditId(), null, (int)2, null);
        }

        private final String getOrCreateEditId() {
            String string;
            EditResponse response;
            EditResponse editResponse;
            String string2;
            File file = IoKt.orNull(this.file);
            String string3 = IoKt.nullOrFull(file != null ? FilesKt.readText$default((File)file, null, (int)1, null) : null);
            if (string3 != null) {
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                string2 = IoKt.marked(this.file, "skipped").exists() ? string4 : null;
            } else {
                string2 = null;
            }
            String editId2 = string2;
            this.fileOps.delete((Action)new Action<DeleteSpec>(this){
                final /* synthetic */ Generator this$0;

                public final void execute(@NotNull DeleteSpec $this$delete) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$delete, (String)"$receiver");
                    $this$delete.delete(new Object[]{EditTaskBase.Companion.getEditIdAndFriends(Generator.access$getFile$p(this.this$0))});
                }
                {
                    this.this$0 = generator;
                }
            });
            if (editId2 == null) {
                editResponse = this.publisher.insertEdit();
            } else {
                IoKt.safeCreateNewFile(IoKt.marked(this.file, "skipped"));
                editResponse = this.publisher.getEdit(editId2);
            }
            EditResponse editResponse2 = response = editResponse;
            if (editResponse2 instanceof EditResponse.Success) {
                string = ((EditResponse.Success)response).getId();
            } else if (editResponse2 instanceof EditResponse.Failure) {
                string = this.handleFailure((EditResponse.Failure)response);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final String handleFailure(EditResponse.Failure response) {
            if (response.isNewApp()) {
                Void void_ = response.rethrow(StringsKt.trimMargin$default((String)("\n                    |No application found for the package name '" + this.appId + "'. The first version of your\n                    |app must be uploaded via the Play Console.\n                "), null, (int)1, null));
                throw null;
            }
            if (response.isInvalidEdit()) {
                Logging.getLogger(GenerateEdit.class).error("Failed to retrieve saved edit, regenerating.");
                return this.getOrCreateEditId();
            }
            if (response.isUnauthorized()) {
                Void void_ = response.rethrow("Service account not authenticated. See the README for instructions:\nhttps://github.com/Triple-T/gradle-play-publisher#service-account");
                throw null;
            }
            Void void_ = response.rethrow();
            throw null;
        }

        @Inject
        public Generator(@NotNull FileSystemOperations fileOps) {
            Intrinsics.checkParameterIsNotNull((Object)fileOps, (String)"fileOps");
            this.fileOps = fileOps;
            Object object = ((Params)this.getParameters()).getEditIdFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.editIdFile.get()");
            File file = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parameters.editIdFile.get().asFile");
            this.file = file;
            this.appId = FilesKt.getNameWithoutExtension((File)this.file);
            File file2 = ((PlayPublisherExtension.Config)((Params)this.getParameters()).getConfig().get()).getServiceAccountCredentials();
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            this.publisher = PlayPublisher.Companion.invoke(file2, ((PlayPublisherExtension.Config)((Params)this.getParameters()).getConfig().get()).getServiceAccountEmail(), this.appId);
        }

        public static final /* synthetic */ File access$getFile$p(Generator $this) {
            return $this.file;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/triplet/gradle/play/tasks/GenerateEdit$Generator$Params;", "Lorg/gradle/workers/WorkParameters;", "config", "Lorg/gradle/api/provider/Property;", "Lcom/github/triplet/gradle/play/PlayPublisherExtension$Config;", "getConfig", "()Lorg/gradle/api/provider/Property;", "editIdFile", "Lorg/gradle/api/file/RegularFileProperty;", "getEditIdFile", "()Lorg/gradle/api/file/RegularFileProperty;", "plugin"})
        public static interface Params
        extends WorkParameters {
            @NotNull
            public Property<PlayPublisherExtension.Config> getConfig();

            @NotNull
            public RegularFileProperty getEditIdFile();
        }
    }
}

