/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.play.tasks;

import com.android.build.gradle.api.ApplicationVariant;
import com.github.triplet.gradle.common.utils.IoKt;
import com.github.triplet.gradle.play.PlayPublisherExtension;
import com.github.triplet.gradle.play.internal.AppDetail;
import com.github.triplet.gradle.play.internal.ImageType;
import com.github.triplet.gradle.play.internal.ListingDetail;
import com.github.triplet.gradle.play.tasks.internal.BootstrapOptions;
import com.github.triplet.gradle.play.tasks.internal.PublishEditTaskBase;
import com.github.triplet.gradle.play.tasks.internal.workers.EditWorkerBase;
import com.github.triplet.gradle.play.tasks.internal.workers.ParamsKt;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.AppDetails;
import com.google.api.services.androidpublisher.model.Image;
import com.google.api.services.androidpublisher.model.ImagesListResponse;
import com.google.api.services.androidpublisher.model.InAppProduct;
import com.google.api.services.androidpublisher.model.InappproductsListResponse;
import com.google.api.services.androidpublisher.model.Listing;
import com.google.api.services.androidpublisher.model.ListingsListResponse;
import com.google.api.services.androidpublisher.model.LocalizedText;
import com.google.api.services.androidpublisher.model.TokenPagination;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TrackRelease;
import com.google.api.services.androidpublisher.model.TracksListResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b \u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0007&'()*+,B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8W@WX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8W@WX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8W@WX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R$\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8W@WX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u0014\u0010\u001a\u001a\u00020\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap;", "Lcom/github/triplet/gradle/play/tasks/internal/PublishEditTaskBase;", "Lcom/github/triplet/gradle/play/tasks/internal/BootstrapOptions;", "extension", "Lcom/github/triplet/gradle/play/PlayPublisherExtension;", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "optionsHolder", "Lcom/github/triplet/gradle/play/tasks/internal/BootstrapOptions$Holder;", "(Lcom/github/triplet/gradle/play/PlayPublisherExtension;Lcom/android/build/gradle/api/ApplicationVariant;Lcom/github/triplet/gradle/play/tasks/internal/BootstrapOptions$Holder;)V", "<set-?>", "", "downloadAppDetails", "getDownloadAppDetails", "()Z", "setDownloadAppDetails", "(Z)V", "downloadListings", "getDownloadListings", "setDownloadListings", "downloadProducts", "getDownloadProducts", "setDownloadProducts", "downloadReleaseNotes", "getDownloadReleaseNotes", "setDownloadReleaseNotes", "srcDir", "Lorg/gradle/api/file/DirectoryProperty;", "getSrcDir", "()Lorg/gradle/api/file/DirectoryProperty;", "bootstrap", "", "bootstrapAppDetails", "executor", "Lorg/gradle/workers/WorkerExecutor;", "bootstrapListings", "bootstrapProducts", "bootstrapReleaseNotes", "Companion", "DetailsDownloader", "ImageDownloader", "ImageFetcher", "ListingsDownloader", "ProductsDownloader", "ReleaseNotesDownloader", "plugin"})
public abstract class Bootstrap
extends PublishEditTaskBase
implements BootstrapOptions {
    private static final Companion Companion = new Companion(null);
    private final /* synthetic */ BootstrapOptions.Holder $$delegate_0;

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getSrcDir();

    @TaskAction
    public final void bootstrap() {
        this.getProject().delete(new Object[]{this.getSrcDir()});
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project $this$serviceOf$iv = project;
        boolean $i$f$serviceOf = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkExpressionValueIsNotNull((Object)serviceRegistry, (String)"(this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(WorkerExecutor.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        WorkerExecutor executor = (WorkerExecutor)object;
        if (this.getDownloadAppDetails()) {
            this.bootstrapAppDetails(executor);
        }
        if (this.getDownloadListings()) {
            this.bootstrapListings(executor);
        }
        if (this.getDownloadReleaseNotes()) {
            this.bootstrapReleaseNotes(executor);
        }
        if (this.getDownloadProducts()) {
            this.bootstrapProducts(executor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void bootstrapAppDetails(WorkerExecutor executor) {
        void workActionClass$iv;
        void $this$submit$iv;
        WorkQueue workQueue = executor.noIsolation();
        Intrinsics.checkExpressionValueIsNotNull((Object)workQueue, (String)"executor.noIsolation()");
        WorkQueue workQueue2 = workQueue;
        Class<DetailsDownloader> clazz = DetailsDownloader.class;
        Action parameterAction$iv = new Action<T>(this){
            final /* synthetic */ Bootstrap this$0;

            public final void execute(@NotNull DetailsDownloader.Params $this$submit) {
                Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                ParamsKt.paramsForBase(this.this$0, $this$submit);
                $this$submit.getDir().set((Provider)this.this$0.getSrcDir());
            }
            {
                this.this$0 = bootstrap;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void bootstrapListings(WorkerExecutor executor) {
        void workActionClass$iv;
        void $this$submit$iv;
        WorkQueue workQueue = executor.noIsolation();
        Intrinsics.checkExpressionValueIsNotNull((Object)workQueue, (String)"executor.noIsolation()");
        WorkQueue workQueue2 = workQueue;
        Class<ListingsDownloader> clazz = ListingsDownloader.class;
        Action parameterAction$iv = new Action<T>(this){
            final /* synthetic */ Bootstrap this$0;

            public final void execute(@NotNull ListingsDownloader.Params $this$submit) {
                Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                ParamsKt.paramsForBase(this.this$0, $this$submit);
                $this$submit.getDir().set(this.this$0.getSrcDir().dir("listings"));
            }
            {
                this.this$0 = bootstrap;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void bootstrapReleaseNotes(WorkerExecutor executor) {
        void workActionClass$iv;
        void $this$submit$iv;
        WorkQueue workQueue = executor.noIsolation();
        Intrinsics.checkExpressionValueIsNotNull((Object)workQueue, (String)"executor.noIsolation()");
        WorkQueue workQueue2 = workQueue;
        Class<ReleaseNotesDownloader> clazz = ReleaseNotesDownloader.class;
        Action parameterAction$iv = new Action<T>(this){
            final /* synthetic */ Bootstrap this$0;

            public final void execute(@NotNull ReleaseNotesDownloader.Params $this$submit) {
                Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                ParamsKt.paramsForBase(this.this$0, $this$submit);
                $this$submit.getDir().set(this.this$0.getSrcDir().dir("release-notes"));
            }
            {
                this.this$0 = bootstrap;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void bootstrapProducts(WorkerExecutor executor) {
        void workActionClass$iv;
        void $this$submit$iv;
        WorkQueue workQueue = executor.noIsolation();
        Intrinsics.checkExpressionValueIsNotNull((Object)workQueue, (String)"executor.noIsolation()");
        WorkQueue workQueue2 = workQueue;
        Class<ProductsDownloader> clazz = ProductsDownloader.class;
        Action parameterAction$iv = new Action<T>(this){
            final /* synthetic */ Bootstrap this$0;

            public final void execute(@NotNull ProductsDownloader.Params $this$submit) {
                Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                ParamsKt.paramsForBase(this.this$0, $this$submit);
                $this$submit.getDir().set(this.this$0.getSrcDir().dir("products"));
            }
            {
                this.this$0 = bootstrap;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
    }

    @Inject
    public Bootstrap(@NotNull PlayPublisherExtension extension, @NotNull ApplicationVariant variant, @NotNull BootstrapOptions.Holder optionsHolder) {
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull((Object)optionsHolder, (String)"optionsHolder");
        super(extension, variant);
        this.$$delegate_0 = optionsHolder;
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }

    @Override
    @Internal
    public boolean getDownloadAppDetails() {
        return this.$$delegate_0.getDownloadAppDetails();
    }

    @Override
    @Option(option="app-details", description="Download app details such as your contact email.")
    public void setDownloadAppDetails(boolean bl) {
        this.$$delegate_0.setDownloadAppDetails(bl);
    }

    @Override
    @Internal
    public boolean getDownloadListings() {
        return this.$$delegate_0.getDownloadListings();
    }

    @Override
    @Option(option="listings", description="Download listings for each language such as your app title and graphics.")
    public void setDownloadListings(boolean bl) {
        this.$$delegate_0.setDownloadListings(bl);
    }

    @Override
    @Internal
    public boolean getDownloadProducts() {
        return this.$$delegate_0.getDownloadProducts();
    }

    @Override
    @Option(option="products", description="Download in-app purchases and subscriptions.")
    public void setDownloadProducts(boolean bl) {
        this.$$delegate_0.setDownloadProducts(bl);
    }

    @Override
    @Internal
    public boolean getDownloadReleaseNotes() {
        return this.$$delegate_0.getDownloadReleaseNotes();
    }

    @Override
    @Option(option="release-notes", description="Download release notes for each language.")
    public void setDownloadReleaseNotes(boolean bl) {
        this.$$delegate_0.setDownloadReleaseNotes(bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$DetailsDownloader;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase;", "Lcom/github/triplet/gradle/play/tasks/Bootstrap$DetailsDownloader$Params;", "()V", "execute", "", "write", "", "detail", "Lcom/github/triplet/gradle/play/internal/AppDetail;", "Params", "plugin"})
    public static abstract class DetailsDownloader
    extends EditWorkerBase<Params> {
        public void execute() {
            block3: {
                AppDetails details;
                String string = "Downloading app details";
                boolean bl = false;
                System.out.println((Object)string);
                AppDetails appDetails = details = (AppDetails)this.getEdits().details().get(this.getAppId(), this.getEditId()).execute();
                Intrinsics.checkExpressionValueIsNotNull((Object)appDetails, (String)"details");
                String string2 = IoKt.nullOrFull(appDetails.getContactEmail());
                if (string2 != null) {
                    this.write(string2, AppDetail.CONTACT_EMAIL);
                }
                String string3 = IoKt.nullOrFull(details.getContactPhone());
                if (string3 != null) {
                    this.write(string3, AppDetail.CONTACT_PHONE);
                }
                String string4 = IoKt.nullOrFull(details.getContactWebsite());
                if (string4 != null) {
                    this.write(string4, AppDetail.CONTACT_WEBSITE);
                }
                String string5 = IoKt.nullOrFull(details.getDefaultLanguage());
                if (string5 == null) break block3;
                this.write(string5, AppDetail.DEFAULT_LANGUAGE);
            }
        }

        private final void write(@NotNull String $this$write, AppDetail detail) {
            Companion companion = Companion;
            RegularFile regularFile = ((Directory)((Params)this.getParameters()).getDir().get()).file(detail.getFileName());
            Intrinsics.checkExpressionValueIsNotNull((Object)regularFile, (String)"parameters.dir.get().file(detail.fileName)");
            companion.write(regularFile, $this$write);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$DetailsDownloader$Params;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase$EditPublishingParams;", "dir", "Lorg/gradle/api/file/DirectoryProperty;", "getDir", "()Lorg/gradle/api/file/DirectoryProperty;", "plugin"})
        public static interface Params
        extends EditWorkerBase.EditPublishingParams {
            @NotNull
            public DirectoryProperty getDir();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00020\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ListingsDownloader;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase;", "Lcom/github/triplet/gradle/play/tasks/Bootstrap$ListingsDownloader$Params;", "executor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "execute", "", "fetchImages", "Lcom/google/api/services/androidpublisher/model/Listing;", "rootDir", "Lorg/gradle/api/file/Directory;", "writeMetadata", "Params", "plugin"})
    public static abstract class ListingsDownloader
    extends EditWorkerBase<Params> {
        private final WorkerExecutor executor;

        public void execute() {
            String string = "Downloading listings";
            boolean bl = false;
            System.out.println((Object)string);
            Object object = this.getEdits().listings().list(this.getAppId(), this.getEditId()).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"edits.listings().list(appId, editId).execute()");
            List list = ((ListingsListResponse)object).getListings();
            if (list == null) {
                return;
            }
            List listings = list;
            for (Listing listing : listings) {
                Directory rootDir;
                Directory directory = (Directory)((Params)this.getParameters()).getDir().get();
                Listing listing2 = listing;
                Intrinsics.checkExpressionValueIsNotNull((Object)listing2, (String)"listing");
                Intrinsics.checkExpressionValueIsNotNull((Object)directory.dir(listing2.getLanguage()), (String)"parameters.dir.get().dir(listing.language)");
                this.writeMetadata(listing, rootDir);
                this.fetchImages(listing, rootDir);
            }
        }

        private final void writeMetadata(@NotNull Listing $this$writeMetadata, Directory rootDir) {
            block3: {
                Function2<String, ListingDetail, Unit> $fun$write$1 = new Function2<String, ListingDetail, Unit>(rootDir){
                    final /* synthetic */ Directory $rootDir;

                    public final void invoke(@NotNull String $this$write, @NotNull ListingDetail detail) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$write, (String)"$this$write");
                        Intrinsics.checkParameterIsNotNull((Object)detail, (String)"detail");
                        Companion companion = Bootstrap.access$Companion();
                        RegularFile regularFile = this.$rootDir.file(detail.getFileName());
                        Intrinsics.checkExpressionValueIsNotNull((Object)regularFile, (String)"rootDir.file(detail.fileName)");
                        companion.write(regularFile, $this$write);
                    }
                    {
                        this.$rootDir = directory;
                        super(2);
                    }
                };
                String string = "Downloading " + $this$writeMetadata.getLanguage() + " listing";
                boolean bl = false;
                System.out.println((Object)string);
                String string2 = IoKt.nullOrFull($this$writeMetadata.getFullDescription());
                if (string2 != null) {
                    $fun$write$1.invoke(string2, ListingDetail.FULL_DESCRIPTION);
                }
                String string3 = IoKt.nullOrFull($this$writeMetadata.getShortDescription());
                if (string3 != null) {
                    $fun$write$1.invoke(string3, ListingDetail.SHORT_DESCRIPTION);
                }
                String string4 = IoKt.nullOrFull($this$writeMetadata.getTitle());
                if (string4 != null) {
                    $fun$write$1.invoke(string4, ListingDetail.TITLE);
                }
                String string5 = IoKt.nullOrFull($this$writeMetadata.getVideo());
                if (string5 == null) break block3;
                $fun$write$1.invoke(string5, ListingDetail.VIDEO);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchImages(@NotNull Listing $this$fetchImages, Directory rootDir) {
            for (ImageType type : ImageType.values()) {
                void workActionClass$iv;
                void $this$submit$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.executor.noIsolation(), (String)"executor.noIsolation()");
                Class<ImageFetcher> clazz = ImageFetcher.class;
                Action parameterAction$iv = new Action<T>(this, $this$fetchImages, rootDir, type){
                    final /* synthetic */ ListingsDownloader this$0;
                    final /* synthetic */ Listing $this_fetchImages;
                    final /* synthetic */ Directory $rootDir;
                    final /* synthetic */ ImageType $type;

                    public final void execute(@NotNull ImageFetcher.Params $this$submit) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                        Params params = (Params)this.this$0.getParameters();
                        Intrinsics.checkExpressionValueIsNotNull((Object)params, (String)"parameters");
                        ParamsKt.copy(params, $this$submit);
                        $this$submit.getDir().set((Object)this.$rootDir.dir("graphics"));
                        $this$submit.getLanguage().set((Object)this.$this_fetchImages.getLanguage());
                        $this$submit.getImageType().set((Object)((Object)this.$type));
                    }
                    {
                        this.this$0 = listingsDownloader;
                        this.$this_fetchImages = listing;
                        this.$rootDir = directory;
                        this.$type = imageType;
                    }
                };
                boolean $i$f$submit = false;
                $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
            }
        }

        @Inject
        public ListingsDownloader(@NotNull WorkerExecutor executor) {
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            this.executor = executor;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ListingsDownloader$Params;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase$EditPublishingParams;", "dir", "Lorg/gradle/api/file/DirectoryProperty;", "getDir", "()Lorg/gradle/api/file/DirectoryProperty;", "plugin"})
        public static interface Params
        extends EditWorkerBase.EditPublishingParams {
            @NotNull
            public DirectoryProperty getDir();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ImageFetcher;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase;", "Lcom/github/triplet/gradle/play/tasks/Bootstrap$ImageFetcher$Params;", "executor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "execute", "", "Params", "plugin"})
    public static abstract class ImageFetcher
    extends EditWorkerBase<Params> {
        private final WorkerExecutor executor;

        /*
         * WARNING - void declaration
         */
        public void execute() {
            String typeName = ((ImageType)((Object)((Params)this.getParameters()).getImageType().get())).getPublishedName();
            Object object = this.getEdits().images().list(this.getAppId(), this.getEditId(), (String)((Params)this.getParameters()).getLanguage().get(), typeName).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"edits.images()\n         \u2026               .execute()");
            List list = ((ImagesListResponse)object).getImages();
            if (list == null) {
                return;
            }
            List images = list;
            Directory directory = ((Directory)((Params)this.getParameters()).getDir().get()).dir(((ImageType)((Object)((Params)this.getParameters()).getImageType().get())).getDirName());
            Intrinsics.checkExpressionValueIsNotNull((Object)directory, (String)"parameters.dir.get().dir\u2026.imageType.get().dirName)");
            Directory imageDir = directory;
            String string = "Downloading " + (String)((Params)this.getParameters()).getLanguage().get() + " listing graphics for type '" + typeName + '\'';
            boolean bl = false;
            System.out.println((Object)string);
            boolean bl2 = false;
            for (Image image : (Iterable)images) {
                void workActionClass$iv;
                void $this$submit$iv;
                void i2;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.executor.noIsolation(), (String)"executor.noIsolation()");
                Class<ImageDownloader> clazz = ImageDownloader.class;
                Action parameterAction$iv = new Action<T>(imageDir, (int)i2, image){
                    final /* synthetic */ Directory $imageDir;
                    final /* synthetic */ int $i;
                    final /* synthetic */ Image $image;

                    public final void execute(@NotNull ImageDownloader.Params $this$submit) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                        $this$submit.getTarget().set((Object)this.$imageDir.file(this.$i + 1 + ".png"));
                        Property<String> property = $this$submit.getUrl();
                        Image image = this.$image;
                        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
                        property.set((Object)image.getUrl());
                    }
                    {
                        this.$imageDir = directory;
                        this.$i = n;
                        this.$image = image;
                    }
                };
                boolean $i$f$submit = false;
                $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
                ++i2;
            }
        }

        @Inject
        public ImageFetcher(@NotNull WorkerExecutor executor) {
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            this.executor = executor;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ImageFetcher$Params;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase$EditPublishingParams;", "dir", "Lorg/gradle/api/file/DirectoryProperty;", "getDir", "()Lorg/gradle/api/file/DirectoryProperty;", "imageType", "Lorg/gradle/api/provider/Property;", "Lcom/github/triplet/gradle/play/internal/ImageType;", "getImageType", "()Lorg/gradle/api/provider/Property;", "language", "", "getLanguage", "plugin"})
        public static interface Params
        extends EditWorkerBase.EditPublishingParams {
            @NotNull
            public DirectoryProperty getDir();

            @NotNull
            public Property<String> getLanguage();

            @NotNull
            public Property<ImageType> getImageType();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ImageDownloader;", "Lorg/gradle/workers/WorkAction;", "Lcom/github/triplet/gradle/play/tasks/Bootstrap$ImageDownloader$Params;", "()V", "execute", "", "Companion", "Params", "plugin"})
    public static abstract class ImageDownloader
    implements WorkAction<Params> {
        @NotNull
        public static final String HIGH_RES_IMAGE_REQUEST = "=h16383";
        private static final Companion Companion = new Companion(null);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Object object = ((Params)this.getParameters()).getTarget().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.target.get()");
            File file = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parameters.target.get().asFile");
            Object object2 = IoKt.safeCreateNewFile(file);
            boolean bl = false;
            object2 = new FileOutputStream((File)object2);
            bl = false;
            Throwable throwable = null;
            try {
                long l;
                Closeable closeable;
                FileOutputStream local = (FileOutputStream)object2;
                boolean bl2 = false;
                try {
                    closeable = new URL((String)((Params)this.getParameters()).getUrl().get() + HIGH_RES_IMAGE_REQUEST).openStream();
                }
                catch (FileNotFoundException e) {
                    closeable = new URL((String)((Params)this.getParameters()).getUrl().get()).openStream();
                }
                InputStream remote = closeable;
                closeable = remote;
                boolean bl3 = false;
                Throwable throwable2 = null;
                try {
                    Closeable it = closeable;
                    boolean bl4 = false;
                    Closeable closeable2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeable2, (String)"it");
                    l = ByteStreamsKt.copyTo$default((InputStream)closeable2, (OutputStream)local, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ImageDownloader$Params;", "Lorg/gradle/workers/WorkParameters;", "target", "Lorg/gradle/api/file/RegularFileProperty;", "getTarget", "()Lorg/gradle/api/file/RegularFileProperty;", "url", "Lorg/gradle/api/provider/Property;", "", "getUrl", "()Lorg/gradle/api/provider/Property;", "plugin"})
        public static interface Params
        extends WorkParameters {
            @NotNull
            public RegularFileProperty getTarget();

            @NotNull
            public Property<String> getUrl();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ImageDownloader$Companion;", "", "()V", "HIGH_RES_IMAGE_REQUEST", "", "plugin"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ReleaseNotesDownloader;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase;", "Lcom/github/triplet/gradle/play/tasks/Bootstrap$ReleaseNotesDownloader$Params;", "()V", "execute", "", "Params", "plugin"})
    public static abstract class ReleaseNotesDownloader
    extends EditWorkerBase<Params> {
        /*
         * Unable to fully structure code
         */
        public void execute() {
            var1_1 = "Downloading release notes";
            var2_2 = false;
            System.out.println((Object)var1_1);
            v0 = this.getEdits().tracks().list(this.getAppId(), this.getEditId()).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"edits.tracks().list(appId, editId).execute()");
            var2_3 = ((TracksListResponse)v0).getTracks();
            var3_4 = false;
            v1 = var2_3;
            if (v1 == null) {
                v1 = CollectionsKt.emptyList();
            }
            tracks = v1;
            var3_5 = tracks.iterator();
            while (var3_5.hasNext()) {
                v2 = track = (Track)var3_5.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"track");
                v3 = v2.getReleases();
                if (v3 == null) ** GOTO lbl-1000
                $this$maxBy$iv = v3;
                $i$f$maxBy = false;
                iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v4 = null;
                } else {
                    maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v4 = maxElem$iv;
                    } else {
                        it = (TrackRelease)maxElem$iv;
                        $i$a$-maxBy-Bootstrap$ReleaseNotesDownloader$execute$notes$1 = false;
                        v5 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                        v6 = v5.getVersionCodes();
                        maxValue$iv = v6 != null && (v6 = (Long)CollectionsKt.max((Iterable)((Iterable)v6))) != null ? v6.longValue() : -9223372036854775808L;
                        do {
                            e$iv = iterator$iv.next();
                            it = (TrackRelease)e$iv;
                            $i$a$-maxBy-Bootstrap$ReleaseNotesDownloader$execute$notes$1 = false;
                            v7 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
                            v8 = v7.getVersionCodes();
                            v9 = v8 != null && (v8 = (Long)CollectionsKt.max((Iterable)((Iterable)v8))) != null ? v8.longValue() : (v$iv = -9223372036854775808L);
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v4 = maxElem$iv;
                    }
                }
                if ((v3 = (TrackRelease)v4) != null) {
                    v10 = v3.getReleaseNotes();
                } else lbl-1000:
                // 2 sources

                {
                    v10 = null;
                }
                $this$maxBy$iv = v10;
                var6_9 = false;
                v11 = $this$maxBy$iv;
                if (v11 == null) {
                    v11 = CollectionsKt.emptyList();
                }
                notes = v11;
                for (LocalizedText note : notes) {
                    v12 = Bootstrap.access$Companion();
                    v13 = (Directory)((Params)this.getParameters()).getDir().get();
                    v14 = new StringBuilder();
                    v15 = note;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"note");
                    v16 = v13.file(v14.append(v15.getLanguage()).append('/').append(track.getTrack()).append(".txt").toString());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"parameters.dir.get().fil\u2026age}/${track.track}.txt\")");
                    v17 = note.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"note.text");
                    v12.write(v16, v17);
                }
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ReleaseNotesDownloader$Params;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase$EditPublishingParams;", "dir", "Lorg/gradle/api/file/DirectoryProperty;", "getDir", "()Lorg/gradle/api/file/DirectoryProperty;", "plugin"})
        public static interface Params
        extends EditWorkerBase.EditPublishingParams {
            @NotNull
            public DirectoryProperty getDir();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J&\u0010\u0006\u001a\n0\u0007R\u00060\bR\u00020\t*\n0\u0007R\u00060\bR\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ProductsDownloader;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase;", "Lcom/github/triplet/gradle/play/tasks/Bootstrap$ProductsDownloader$Params;", "()V", "execute", "", "withToken", "Lcom/google/api/services/androidpublisher/AndroidPublisher$Inappproducts$List;", "Lcom/google/api/services/androidpublisher/AndroidPublisher$Inappproducts;", "Lcom/google/api/services/androidpublisher/AndroidPublisher;", "token", "", "Params", "plugin"})
    public static abstract class ProductsDownloader
    extends EditWorkerBase<Params> {
        public void execute() {
            TokenPagination tokenPagination;
            String string = "Downloading in-app products";
            boolean bl = false;
            System.out.println((Object)string);
            String token = null;
            do {
                InappproductsListResponse response;
                AndroidPublisher.Inappproducts.List list = this.getPublisher().inappproducts().list(this.getAppId());
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"publisher.inappproducts().list(appId)");
                InappproductsListResponse inappproductsListResponse = response = (InappproductsListResponse)this.withToken(list, token).execute();
                Intrinsics.checkExpressionValueIsNotNull((Object)inappproductsListResponse, (String)"response");
                List list2 = inappproductsListResponse.getInappproduct();
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        InAppProduct it = (InAppProduct)element$iv;
                        boolean bl2 = false;
                        Companion companion = Companion;
                        Directory directory = (Directory)((Params)this.getParameters()).getDir().get();
                        StringBuilder stringBuilder = new StringBuilder();
                        InAppProduct inAppProduct = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inAppProduct, (String)"it");
                        RegularFile regularFile = directory.file(stringBuilder.append(inAppProduct.getSku()).append(".json").toString());
                        Intrinsics.checkExpressionValueIsNotNull((Object)regularFile, (String)"parameters.dir.get().file(\"${it.sku}.json\")");
                        String string2 = JacksonFactory.getDefaultInstance().toPrettyString((Object)it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JacksonFactory.getDefaul\u2026ance().toPrettyString(it)");
                        companion.write(regularFile, string2);
                    }
                }
                tokenPagination = response.getTokenPagination();
            } while ((token = tokenPagination != null ? tokenPagination.getNextPageToken() : null) != null);
        }

        private final AndroidPublisher.Inappproducts.List withToken(@NotNull AndroidPublisher.Inappproducts.List $this$withToken, String token) {
            AndroidPublisher.Inappproducts.List list = $this$withToken;
            boolean bl = false;
            boolean bl2 = false;
            AndroidPublisher.Inappproducts.List $this$apply = list;
            boolean bl3 = false;
            $this$apply.setToken(token);
            return list;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$ProductsDownloader$Params;", "Lcom/github/triplet/gradle/play/tasks/internal/workers/EditWorkerBase$EditPublishingParams;", "dir", "Lorg/gradle/api/file/DirectoryProperty;", "getDir", "()Lorg/gradle/api/file/DirectoryProperty;", "plugin"})
        public static interface Params
        extends EditWorkerBase.EditPublishingParams {
            @NotNull
            public DirectoryProperty getDir();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/github/triplet/gradle/play/tasks/Bootstrap$Companion;", "", "()V", "write", "", "Lorg/gradle/api/file/RegularFile;", "text", "", "plugin"})
    private static final class Companion {
        public final void write(@NotNull RegularFile $this$write, @NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)$this$write, (String)"$this$write");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            File file = $this$write.getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"asFile");
            FilesKt.writeText$default((File)IoKt.safeCreateNewFile(file), (String)(text + "\n"), null, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

