/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.androidpublisher.internal;

import com.github.triplet.gradle.androidpublisher.EditResponse;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.androidpublisher.UpdateProductResponse;
import com.github.triplet.gradle.androidpublisher.UploadInternalSharingArtifactResponse;
import com.github.triplet.gradle.androidpublisher.internal.AndroidPublisherKt;
import com.github.triplet.gradle.androidpublisher.internal.DefaultPlayPublisher$WhenMappings;
import com.github.triplet.gradle.androidpublisher.internal.InternalPlayPublisher;
import com.github.triplet.gradle.androidpublisher.internal.ServiceAccountAuth;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse;
import com.google.api.services.androidpublisher.model.ExpansionFile;
import com.google.api.services.androidpublisher.model.InAppProduct;
import com.google.api.services.androidpublisher.model.InternalAppSharingArtifact;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TrackRelease;
import com.google.api.services.androidpublisher.model.TracksListResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 62\u00020\u0001:\u000267B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0018H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0018H\u0016J \u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\fH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010$\u001a\u00020\u0018H\u0016J\u0010\u0010.\u001a\u00020-2\u0006\u0010'\u001a\u00020\u0018H\u0016J7\u0010/\u001a\u0002H0\"\u0004\b\u0000\u00101\"\u000e\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H102*\u0002H02\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u00105R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher;", "Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;", "publisher", "Lcom/google/api/services/androidpublisher/AndroidPublisher;", "appId", "", "(Lcom/google/api/services/androidpublisher/AndroidPublisher;Ljava/lang/String;)V", "attachObb", "", "editId", "type", "appVersion", "", "obbVersion", "commitEdit", "id", "getEdit", "Lcom/github/triplet/gradle/androidpublisher/EditResponse;", "getTrack", "Lcom/google/api/services/androidpublisher/model/Track;", "track", "insertEdit", "insertInAppProduct", "productFile", "Ljava/io/File;", "listTracks", "", "readProductFile", "Lcom/google/api/services/androidpublisher/model/InAppProduct;", "kotlin.jvm.PlatformType", "product", "updateInAppProduct", "Lcom/github/triplet/gradle/androidpublisher/UpdateProductResponse;", "updateTrack", "uploadApk", "Lcom/google/api/services/androidpublisher/model/Apk;", "apkFile", "uploadBundle", "Lcom/google/api/services/androidpublisher/model/Bundle;", "bundleFile", "uploadDeobfuscationFile", "Lcom/google/api/services/androidpublisher/model/DeobfuscationFilesUploadResponse;", "mappingFile", "versionCode", "uploadInternalSharingApk", "Lcom/github/triplet/gradle/androidpublisher/UploadInternalSharingArtifactResponse;", "uploadInternalSharingBundle", "trackUploadProgress", "R", "T", "Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;", "thing", "file", "(Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;Ljava/lang/String;Ljava/io/File;)Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;", "Companion", "Factory", "android-publisher"})
public final class DefaultPlayPublisher
implements InternalPlayPublisher {
    private final AndroidPublisher publisher;
    private final String appId;
    @NotNull
    public static final String MIME_TYPE_STREAM = "application/octet-stream";
    @NotNull
    public static final String MIME_TYPE_APK = "application/vnd.android.package-archive";
    private static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public EditResponse insertEdit() {
        EditResponse editResponse;
        try {
            Object object = this.publisher.edits().insert(this.appId, null).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"publisher.edits().insert(appId, null).execute()");
            String string = ((AppEdit)object).getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"publisher.edits().insert(appId, null).execute().id");
            editResponse = new EditResponse.Success(string);
        }
        catch (GoogleJsonResponseException e) {
            editResponse = new EditResponse.Failure(e);
        }
        return editResponse;
    }

    @Override
    @NotNull
    public EditResponse getEdit(@NotNull String id) {
        EditResponse editResponse;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        try {
            Object object = this.publisher.edits().get(this.appId, id).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"publisher.edits().get(appId, id).execute()");
            String string = ((AppEdit)object).getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"publisher.edits().get(appId, id).execute().id");
            editResponse = new EditResponse.Success(string);
        }
        catch (GoogleJsonResponseException e) {
            editResponse = new EditResponse.Failure(e);
        }
        return editResponse;
    }

    @Override
    public void commitEdit(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.publisher.edits().commit(this.appId, id).execute();
    }

    @Override
    @NotNull
    public Track getTrack(@NotNull String editId2, @NotNull String track) {
        Intrinsics.checkParameterIsNotNull((Object)editId2, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)track, (String)"track");
        Object object = this.publisher.edits().tracks().get(this.appId, editId2, track).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"publisher.edits().tracks\u2026 editId, track).execute()");
        return (Track)object;
    }

    @Override
    @NotNull
    public List<Track> listTracks(@NotNull String editId2) {
        Intrinsics.checkParameterIsNotNull((Object)editId2, (String)"editId");
        Object object = this.publisher.edits().tracks().list(this.appId, editId2).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"publisher.edits().tracks\u2026(appId, editId).execute()");
        List list = ((TracksListResponse)object).getTracks();
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateTrack(@NotNull String editId2, @NotNull Track track) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        TrackRelease it;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)editId2, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)track, (String)"track");
        StringBuilder stringBuilder = new StringBuilder().append("Updating ");
        List list = track.getReleases();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"track.releases");
        Object object = list;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TrackRelease trackRelease = (TrackRelease)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = v2.getStatus();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        StringBuilder stringBuilder3 = stringBuilder2.append(CollectionsKt.distinct((Iterable)collection)).append(" release ").append('(').append(this.appId).append(':');
        List list2 = track.getReleases();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"track.releases");
        $this$map$iv = list2;
        stringBuilder2 = stringBuilder3;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (TrackRelease)element$iv$iv;
            boolean bl = false;
            TrackRelease trackRelease = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)trackRelease, (String)"it");
            List list3 = trackRelease.getVersionCodes();
            boolean bl2 = false;
            List list4 = list3;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        object = stringBuilder2.append(collection).append(") ").append("in track '").append(track.getTrack()).append('\'').toString();
        boolean bl = false;
        System.out.println(object);
        this.publisher.edits().tracks().update(this.appId, editId2, track.getTrack(), track).execute();
    }

    @Override
    @NotNull
    public Bundle uploadBundle(@NotNull String editId2, @NotNull File bundleFile) {
        Intrinsics.checkParameterIsNotNull((Object)editId2, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
        FileContent content = new FileContent(MIME_TYPE_STREAM, bundleFile);
        Object object = ((AndroidPublisher.Edits.Bundles.Upload)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.edits().bundles().upload(this.appId, editId2, (AbstractInputStreamContent)content), "App Bundle", bundleFile)).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"publisher.edits().bundle\u2026               .execute()");
        return (Bundle)object;
    }

    @Override
    @NotNull
    public Apk uploadApk(@NotNull String editId2, @NotNull File apkFile) {
        Intrinsics.checkParameterIsNotNull((Object)editId2, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)apkFile, (String)"apkFile");
        FileContent content = new FileContent(MIME_TYPE_APK, apkFile);
        Object object = ((AndroidPublisher.Edits.Apks.Upload)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.edits().apks().upload(this.appId, editId2, (AbstractInputStreamContent)content), "APK", apkFile)).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"publisher.edits().apks()\u2026               .execute()");
        return (Apk)object;
    }

    @Override
    public void attachObb(@NotNull String editId2, @NotNull String type, int appVersion, int obbVersion) {
        Intrinsics.checkParameterIsNotNull((Object)editId2, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        ExpansionFile expansionFile = new ExpansionFile();
        boolean bl = false;
        boolean bl2 = false;
        ExpansionFile it = expansionFile;
        boolean bl3 = false;
        it.setReferencesVersion(Integer.valueOf(obbVersion));
        ExpansionFile obb = expansionFile;
        this.publisher.edits().expansionfiles().update(this.appId, editId2, Integer.valueOf(appVersion), type, obb).execute();
    }

    @Override
    @NotNull
    public DeobfuscationFilesUploadResponse uploadDeobfuscationFile(@NotNull String editId2, @NotNull File mappingFile, int versionCode) {
        Intrinsics.checkParameterIsNotNull((Object)editId2, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)mappingFile, (String)"mappingFile");
        FileContent mapping = new FileContent(MIME_TYPE_STREAM, mappingFile);
        Object object = ((AndroidPublisher.Edits.Deobfuscationfiles.Upload)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.edits().deobfuscationfiles().upload(this.appId, editId2, Integer.valueOf(versionCode), "proguard", (AbstractInputStreamContent)mapping), "mapping file", mappingFile)).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"publisher.edits().deobfu\u2026               .execute()");
        return (DeobfuscationFilesUploadResponse)object;
    }

    @Override
    @NotNull
    public UploadInternalSharingArtifactResponse uploadInternalSharingBundle(@NotNull File bundleFile) {
        Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
        InternalAppSharingArtifact bundle = (InternalAppSharingArtifact)((AndroidPublisher.Internalappsharingartifacts.Uploadbundle)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.internalappsharingartifacts().uploadbundle(this.appId, (AbstractInputStreamContent)new FileContent(MIME_TYPE_STREAM, bundleFile)), "App Bundle", bundleFile)).execute();
        String string = bundle.toPrettyString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundle.toPrettyString()");
        InternalAppSharingArtifact internalAppSharingArtifact = bundle;
        Intrinsics.checkExpressionValueIsNotNull((Object)internalAppSharingArtifact, (String)"bundle");
        String string2 = internalAppSharingArtifact.getDownloadUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"bundle.downloadUrl");
        return new UploadInternalSharingArtifactResponse(string, string2);
    }

    @Override
    @NotNull
    public UploadInternalSharingArtifactResponse uploadInternalSharingApk(@NotNull File apkFile) {
        Intrinsics.checkParameterIsNotNull((Object)apkFile, (String)"apkFile");
        InternalAppSharingArtifact apk = (InternalAppSharingArtifact)((AndroidPublisher.Internalappsharingartifacts.Uploadapk)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.internalappsharingartifacts().uploadapk(this.appId, (AbstractInputStreamContent)new FileContent(MIME_TYPE_APK, apkFile)), "APK", apkFile)).execute();
        String string = apk.toPrettyString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apk.toPrettyString()");
        InternalAppSharingArtifact internalAppSharingArtifact = apk;
        Intrinsics.checkExpressionValueIsNotNull((Object)internalAppSharingArtifact, (String)"apk");
        String string2 = internalAppSharingArtifact.getDownloadUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"apk.downloadUrl");
        return new UploadInternalSharingArtifactResponse(string, string2);
    }

    @Override
    public void insertInAppProduct(@NotNull File productFile) {
        Intrinsics.checkParameterIsNotNull((Object)productFile, (String)"productFile");
        AndroidPublisher.Inappproducts.Insert insert = this.publisher.inappproducts().insert(this.appId, this.readProductFile(productFile));
        boolean bl = false;
        boolean bl2 = false;
        AndroidPublisher.Inappproducts.Insert $this$apply = insert;
        boolean bl3 = false;
        $this$apply.setAutoConvertMissingPrices(Boolean.valueOf(true));
        insert.execute();
    }

    @Override
    @NotNull
    public UpdateProductResponse updateInAppProduct(@NotNull File productFile) {
        Intrinsics.checkParameterIsNotNull((Object)productFile, (String)"productFile");
        InAppProduct product = this.readProductFile(productFile);
        try {
            AndroidPublisher.Inappproducts inappproducts = this.publisher.inappproducts();
            InAppProduct inAppProduct = product;
            Intrinsics.checkExpressionValueIsNotNull((Object)inAppProduct, (String)"product");
            AndroidPublisher.Inappproducts.Update update = inappproducts.update(this.appId, inAppProduct.getSku(), product);
            boolean bl = false;
            boolean bl2 = false;
            AndroidPublisher.Inappproducts.Update $this$apply = update;
            boolean bl3 = false;
            $this$apply.setAutoConvertMissingPrices(Boolean.valueOf(true));
            update.execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                return new UpdateProductResponse(true);
            }
            throw (Throwable)e;
        }
        return new UpdateProductResponse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InAppProduct readProductFile(File product) {
        InAppProduct inAppProduct;
        Object object = product;
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl2 = false;
            inAppProduct = (InAppProduct)JacksonFactory.getDefaultInstance().createJsonParser((InputStream)it).parse(InAppProduct.class);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return inAppProduct;
    }

    private final <T, R extends AbstractGoogleClientRequest<T>> R trackUploadProgress(@NotNull R $this$trackUploadProgress, String thing, File file) {
        block0: {
            MediaHttpUploader mediaHttpUploader = $this$trackUploadProgress.getMediaHttpUploader();
            if (mediaHttpUploader == null) break block0;
            mediaHttpUploader.setProgressListener(new MediaHttpUploaderProgressListener(thing, file){
                final /* synthetic */ String $thing;
                final /* synthetic */ File $file;

                public final void progressChanged(MediaHttpUploader it) {
                    MediaHttpUploader mediaHttpUploader = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mediaHttpUploader, (String)"it");
                    MediaHttpUploader.UploadState uploadState = mediaHttpUploader.getUploadState();
                    if (uploadState != null) {
                        switch (DefaultPlayPublisher$WhenMappings.$EnumSwitchMapping$0[uploadState.ordinal()]) {
                            case 1: {
                                String string = "Starting " + this.$thing + " upload: " + this.$file;
                                boolean bl = false;
                                System.out.println((Object)string);
                                break;
                            }
                            case 2: {
                                String string = "Uploading " + this.$thing + ": " + MathKt.roundToInt((double)(it.getProgress() * (double)100)) + "% complete";
                                boolean bl = false;
                                System.out.println((Object)string);
                                break;
                            }
                            case 3: {
                                String string = StringsKt.capitalize((String)this.$thing) + " upload complete";
                                boolean bl = false;
                                System.out.println((Object)string);
                                break;
                            }
                        }
                    }
                }
                {
                    this.$thing = string;
                    this.$file = file;
                }
            });
        }
        return $this$trackUploadProgress;
    }

    public DefaultPlayPublisher(@NotNull AndroidPublisher publisher2, @NotNull String appId) {
        Intrinsics.checkParameterIsNotNull((Object)publisher2, (String)"publisher");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        this.publisher = publisher2;
        this.appId = appId;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher$Factory;", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher$Factory;", "()V", "create", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "credentials", "Ljava/io/File;", "email", "", "appId", "android-publisher"})
    public static final class Factory
    implements PlayPublisher.Factory {
        @Override
        @NotNull
        public PlayPublisher create(@NotNull File credentials, @Nullable String email, @NotNull String appId) {
            Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
            Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
            AndroidPublisher publisher2 = AndroidPublisherKt.createPublisher(new ServiceAccountAuth(credentials, email));
            return new DefaultPlayPublisher(publisher2, appId);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher$Companion;", "", "()V", "MIME_TYPE_APK", "", "MIME_TYPE_STREAM", "android-publisher"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

