/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.androidpublisher.internal;

import com.github.triplet.gradle.androidpublisher.internal.ServiceAccountAuth;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0080\u0004\u00a8\u0006\u000b"}, d2={"buildTransport", "Lcom/google/api/client/http/javanet/NetHttpTransport;", "createPublisher", "Lcom/google/api/services/androidpublisher/AndroidPublisher;", "auth", "Lcom/github/triplet/gradle/androidpublisher/internal/ServiceAccountAuth;", "has", "", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "error", "", "android-publisher"})
public final class AndroidPublisherKt {
    @NotNull
    public static final AndroidPublisher createPublisher(@NotNull ServiceAccountAuth auth) {
        GoogleCredential googleCredential;
        Intrinsics.checkParameterIsNotNull((Object)auth, (String)"auth");
        NetHttpTransport transport = AndroidPublisherKt.buildTransport();
        JacksonFactory factory = JacksonFactory.getDefaultInstance();
        if (auth.getEmail() == null) {
            File file = auth.getCredentials();
            boolean bl = false;
            googleCredential = GoogleCredential.fromStream((InputStream)new FileInputStream(file), (HttpTransport)((HttpTransport)transport), (JsonFactory)((JsonFactory)factory)).createScoped((Collection)CollectionsKt.listOf((Object)"https://www.googleapis.com/auth/androidpublisher"));
        } else {
            googleCredential = new GoogleCredential.Builder().setTransport((HttpTransport)transport).setJsonFactory((JsonFactory)factory).setServiceAccountId(auth.getEmail()).setServiceAccountPrivateKeyFromP12File(auth.getCredentials()).setServiceAccountScopes((Collection)CollectionsKt.listOf((Object)"https://www.googleapis.com/auth/androidpublisher")).build();
        }
        GoogleCredential credential = googleCredential;
        AndroidPublisher androidPublisher = new AndroidPublisher.Builder((HttpTransport)transport, (JsonFactory)JacksonFactory.getDefaultInstance(), new HttpRequestInitializer(credential){
            final /* synthetic */ GoogleCredential $credential;

            public final void initialize(HttpRequest it) {
                this.$credential.initialize(it.setReadTimeout(0));
            }
            {
                this.$credential = googleCredential;
            }
        }).setApplicationName("gradle-play-publisher").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidPublisher, (String)"AndroidPublisher.Builder\u2026Name(PLUGIN_NAME).build()");
        return androidPublisher;
    }

    public static final boolean has(@NotNull GoogleJsonResponseException $this$has, @NotNull String error) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$this$has, (String)"$this$has");
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            GoogleJsonError googleJsonError = $this$has.getDetails();
            List list = googleJsonError != null ? googleJsonError.getErrors() : null;
            boolean bl2 = false;
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GoogleJsonError.ErrorInfo it = (GoogleJsonError.ErrorInfo)element$iv;
                    boolean bl3 = false;
                    GoogleJsonError.ErrorInfo errorInfo = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)errorInfo, (String)"it");
                    if (!Intrinsics.areEqual((Object)errorInfo.getReason(), (Object)error)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NetHttpTransport buildTransport() {
        NetHttpTransport netHttpTransport;
        String trustStore = System.getProperty("javax.net.ssl.trustStore", null);
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", null);
        if (trustStore == null) {
            netHttpTransport = GoogleNetHttpTransport.newTrustedTransport();
        } else {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            Closeable closeable = new FileInputStream(trustStore);
            boolean bl = false;
            Throwable throwable = null;
            try {
                char[] cArray;
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl2 = false;
                KeyStore keyStore = ks;
                InputStream inputStream = fis;
                String string = trustStorePassword;
                if (string != null) {
                    String string2 = string;
                    InputStream inputStream2 = inputStream;
                    KeyStore keyStore2 = keyStore;
                    boolean bl3 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray2 = string3.toCharArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
                    char[] cArray3 = cArray2;
                    keyStore = keyStore2;
                    inputStream = inputStream2;
                    cArray = cArray3;
                } else {
                    cArray = null;
                }
                keyStore.load(inputStream, cArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            netHttpTransport = new NetHttpTransport.Builder().trustCertificates(ks).build();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)netHttpTransport, (String)"if (trustStore == null) \u2026ficates(ks).build()\n    }");
        return netHttpTransport;
    }
}

