/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\b\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/triniwiz/canvas/TNSTextEncoder;", "", "()V", "encoding", "", "(Ljava/lang/String;)V", "getEncoding", "()Ljava/lang/String;", "nativeEncoder", "", "encode", "Ljava/nio/ByteBuffer;", "text", "finalize", "", "init", "Companion", "canvas_release"})
public final class TNSTextEncoder {
    private long nativeEncoder;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void init(String encoding) {
        this.nativeEncoder = TNSTextEncoder.Companion.nativeInit(encoding);
    }

    protected final void finalize() throws Throwable {
        TNSTextEncoder.Companion.nativeDestroy(this.nativeEncoder);
    }

    @NotNull
    public final String getEncoding() {
        return TNSTextEncoder.Companion.nativeGetEncoding(this.nativeEncoder);
    }

    @NotNull
    public final ByteBuffer encode(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        byte[] buf = TNSTextEncoder.Companion.nativeEncode(this.nativeEncoder, text);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"ByteBuffer.wrap(buf)");
        return byteBuffer;
    }

    public TNSTextEncoder() {
        this.init("utf-8");
    }

    public TNSTextEncoder(@NotNull String encoding) {
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        this.init(encoding);
    }

    @JvmStatic
    private static final native long nativeInit(String var0);

    @JvmStatic
    private static final native void nativeDestroy(long var0);

    @JvmStatic
    private static final native String nativeGetEncoding(long var0);

    @JvmStatic
    private static final native byte[] nativeEncode(long var0, String var2);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0083 J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0083 J\u0011\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0083 J\u0011\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0083 \u00a8\u0006\u000e"}, d2={"Lcom/github/triniwiz/canvas/TNSTextEncoder$Companion;", "", "()V", "nativeDestroy", "", "encoder", "", "nativeEncode", "", "text", "", "nativeGetEncoding", "nativeInit", "encoding", "canvas_release"})
    public static final class Companion {
        @JvmStatic
        private final long nativeInit(String string) {
            return TNSTextEncoder.nativeInit(string);
        }

        @JvmStatic
        private final void nativeDestroy(long l) {
            TNSTextEncoder.nativeDestroy(l);
        }

        @JvmStatic
        private final String nativeGetEncoding(long l) {
            return TNSTextEncoder.nativeGetEncoding(l);
        }

        @JvmStatic
        private final byte[] nativeEncode(long l, String string) {
            return TNSTextEncoder.nativeEncode(l, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

