/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.GLContext;

public class GLViewSV
extends SurfaceView
implements SurfaceHolder.Callback {
    private boolean isCreated = false;
    private boolean isCreatedWithZeroSized = false;
    private GLContext mGLContext;
    private CanvasView.Listener mListener;

    public GLViewSV(Context context) {
        super(context);
        this.init();
    }

    public GLViewSV(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    void init() {
        this.mGLContext = new GLContext();
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void flush() {
        this.mGLContext.flush();
    }

    public GLContext getGLContext() {
        return this.mGLContext;
    }

    public void queueEvent(Runnable runnable) {
        this.mGLContext.queueEvent(runnable);
    }

    public void setListener(CanvasView.Listener listener) {
        this.mListener = listener;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.isCreated) {
            this.isCreatedWithZeroSized = true;
            this.isCreated = true;
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.isCreatedWithZeroSized && (width != 0 || height != 0)) {
            this.mGLContext.init(holder.getSurface());
            this.isCreatedWithZeroSized = false;
            if (this.mListener != null) {
                this.mListener.contextReady();
            }
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.isCreated = false;
    }
}

