/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.GLView;
import com.github.triniwiz.canvas.Utils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;

public class GLContext {
    public WeakReference<GLView> glView;
    private BlockingQueue<Runnable> mQueue = new LinkedBlockingQueue<Runnable>();
    GLThread mGLThread;
    static final String TAG = "GLContext";
    private javax.microedition.khronos.egl.EGLDisplay mEGLDisplay;
    private EGLSurface mEGLSurface;
    private SurfaceTexture offscreenTexture;
    private int textureId = 0;
    private EGLContext mEGLContext;
    private EGLConfig mEGLConfig;
    private EGL10 mEGL;
    boolean alpha = true;
    boolean antialias = true;
    boolean depth = true;
    boolean failIfMajorPerformanceCaveat = false;
    String powerPreference = "default";
    boolean premultipliedAlpha = true;
    boolean preserveDrawingBuffer = false;
    boolean stencil = false;
    boolean desynchronized = false;
    boolean xrCompatible = false;
    WeakReference<CanvasView> reference;

    public boolean isHeadless() {
        if (this.mGLThread != null) {
            return this.mGLThread.mSurface == null;
        }
        return true;
    }

    public void queueEvent(Runnable runnable) {
        this.mQueue.add(runnable);
    }

    public void init(Object texture) {
        if (this.mGLThread != null) {
            return;
        }
        this.mGLThread = new GLThread(texture);
        this.mGLThread.setPriority(10);
    }

    void startGLThread() {
        this.mGLThread.start();
    }

    void resize(final int width, final int height) {
        CanvasView canvasView;
        if (this.reference != null && (canvasView = (CanvasView)((Object)this.reference.get())) != null) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (GLContext.this.offscreenTexture != null) {
                        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                        GLES20.glClear((int)16384);
                        if (!GLContext.this.swapBuffers(GLContext.this.mEGLSurface)) {
                            Log.e((String)GLContext.TAG, (String)"Cannot swap buffers!");
                        }
                        GLContext.this.offscreenTexture.release();
                        GLContext.this.offscreenTexture = null;
                        GLContext.this.textureId = GLContext.this.textureId + 1;
                        GLContext.this.offscreenTexture = new SurfaceTexture(GLContext.this.textureId);
                        GLContext.this.offscreenTexture.setDefaultBufferSize(width, height);
                        GLContext.this.mGLThread.mSurface = GLContext.this.offscreenTexture;
                        GLContext.this.mEGLSurface = GLContext.this.createSurface(GLContext.this.mEGLConfig, GLContext.this.offscreenTexture);
                        if (GLContext.this.mEGLSurface == null || GLContext.this.mEGLSurface == EGL10.EGL_NO_SURFACE) {
                            int error = GLContext.this.mEGL.eglGetError();
                            throw new RuntimeException("eglCreateWindowSurface failed " + GLUtils.getEGLErrorString((int)error));
                        }
                        if (canvasView.canvas > 0L) {
                            int[] frameBuffers = new int[1];
                            GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                            canvasView.canvas = CanvasView.nativeResize(canvasView.canvas, frameBuffers[0], canvasView.getDrawingBufferWidth(), canvasView.getDrawingBufferHeight(), canvasView.scale);
                            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
                        }
                    } else {
                        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                        GLES20.glClear((int)16384);
                        if (!GLContext.this.swapBuffers(GLContext.this.mEGLSurface)) {
                            Log.e((String)GLContext.TAG, (String)"Cannot swap buffers!");
                        }
                        if (canvasView.canvas > 0L) {
                            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
                            int[] frameBuffers = new int[1];
                            GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                            canvasView.canvas = CanvasView.nativeResize(canvasView.canvas, frameBuffers[0], canvasView.getDrawingBufferWidth(), canvasView.getDrawingBufferHeight(), canvasView.scale);
                        }
                    }
                }
            });
        }
    }

    public void flush() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GLContext.this.reference != null) {
                    CanvasView canvasView = (CanvasView)((Object)GLContext.this.reference.get());
                    if (canvasView != null && canvasView.canvas != 0L && canvasView.pendingInvalidate) {
                        canvasView.canvas = CanvasView.nativeFlush(canvasView.canvas);
                        if (!GLContext.this.swapBuffers(GLContext.this.mEGLSurface)) {
                            Log.e((String)GLContext.TAG, (String)"Cannot swap buffers!");
                        }
                        canvasView.pendingInvalidate = false;
                    } else {
                        if (!GLContext.this.swapBuffers(GLContext.this.mEGLSurface)) {
                            Log.e((String)GLContext.TAG, (String)"Cannot swap buffers!");
                        }
                        if (canvasView != null) {
                            canvasView.pendingInvalidate = false;
                        }
                    }
                }
            }
        });
    }

    public EGLSurface createSurface(EGLConfig config, Object surface) {
        if (surface == null) {
            int width = 1;
            int height = 1;
            if (this.reference != null) {
                CanvasView view = (CanvasView)((Object)this.reference.get());
                if (view != null) {
                    width = view.getWidth();
                    height = view.getHeight();
                }
                if (width == 0) {
                    width = 1;
                }
                if (height == 0) {
                    height = 1;
                }
            }
            int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
            ++this.textureId;
            this.offscreenTexture = new SurfaceTexture(this.textureId);
            this.offscreenTexture.setDefaultBufferSize(width, height);
            return this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, config, (Object)this.offscreenTexture, null);
        }
        return this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, config, surface, null);
    }

    public void onPause() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GLContext.this.mEGL != null) {
                    GLContext.this.mEGL.eglMakeCurrent(GLContext.this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                }
                if (GLContext.this.mGLThread != null) {
                    GLContext.this.mGLThread.setPaused(false);
                }
            }
        });
    }

    public void onResume() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GLContext.this.mGLThread != null) {
                    GLContext.this.mGLThread.setPaused(false);
                }
            }
        });
    }

    public boolean makeCurrent(EGLSurface surface) {
        return this.mEGL.eglMakeCurrent(this.mEGLDisplay, surface, surface, this.mEGLContext);
    }

    public boolean destroySurface(EGLSurface surface) {
        return this.mEGL.eglDestroySurface(this.mEGLDisplay, surface);
    }

    public boolean swapBuffers(EGLSurface surface) {
        return this.mEGL.eglSwapBuffers(this.mEGLDisplay, surface);
    }

    public boolean isGLThreadStarted() {
        if (this.mGLThread == null) {
            return false;
        }
        return this.mGLThread.isStarted;
    }

    public void destroy() {
        if (this.mGLThread != null) {
            try {
                this.mGLThread.interrupt();
                this.mGLThread.join();
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"Can't interrupt GL thread.", (Throwable)e);
            }
            this.mGLThread = null;
        }
    }

    class GLThread
    extends Thread {
        boolean isStarted = false;
        boolean isPaused = false;
        CanvasView.ContextType type = CanvasView.ContextType.NONE;
        private Object mSurface;
        private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
        private static final int EGL_CONTEXT_CLIENT_MINOR_VERSION = 12539;

        public synchronized void setPaused(boolean paused) {
            this.isPaused = paused;
        }

        @Override
        public synchronized void start() {
            super.start();
            this.isStarted = true;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.isStarted = false;
        }

        public GLThread() {
            this.mSurface = null;
        }

        public GLThread(Object texture) {
            this.mSurface = texture;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SuppressLint(value={"InlinedApi"})
        private void initEGL() {
            boolean didEnableBufferPreservation;
            int last;
            CanvasView view = (CanvasView)((Object)GLContext.this.reference.get());
            GLContext.this.mEGL = (EGL10)EGLContext.getEGL();
            GLContext.this.mEGLDisplay = GLContext.this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (GLContext.this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed " + GLUtils.getEGLErrorString((int)GLContext.this.mEGL.eglGetError()));
            }
            int[] version = new int[2];
            if (!GLContext.this.mEGL.eglInitialize(GLContext.this.mEGLDisplay, version)) {
                throw new RuntimeException("eglInitialize failed " + GLUtils.getEGLErrorString((int)GLContext.this.mEGL.eglGetError()));
            }
            int[] configsCount = new int[1];
            EGLConfig[] configs = new EGLConfig[1];
            int type = 4;
            int depthSize = 16;
            int stencilSize = 0;
            boolean useAlpha = GLContext.this.alpha;
            boolean enableBufferPreservation = GLContext.this.preserveDrawingBuffer;
            if (view != null) {
                if (view.glVersion > 2 && view.actualContextType.equals("webgl2")) {
                    type = 64;
                }
                if (view.contextStencil && view.contextType != CanvasView.ContextType.CANVAS) {
                    stencilSize = 8;
                    GLContext.this.stencil = true;
                }
                if (!view.contextDepth || view.contextType == CanvasView.ContextType.CANVAS) {
                    GLContext.this.depth = false;
                    depthSize = 0;
                }
                enableBufferPreservation = view.contextPreserveDrawingBuffer;
                useAlpha = view.contextAlpha;
                GLContext.this.antialias = view.contextType == CanvasView.ContextType.CANVAS ? false : view.contextAntialias;
            }
            int[] configSpec = new int[]{12352, type, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, depthSize, 12326, stencilSize};
            if (GLContext.this.antialias) {
                configSpec = Arrays.copyOf(configSpec, configSpec.length + 5);
                last = configSpec.length - 1;
                configSpec[last - 4] = 12338;
                configSpec[last - 3] = 1;
                configSpec[last - 2] = 12337;
                configSpec[last - 1] = 4;
                configSpec[last] = 12344;
            } else {
                configSpec = Arrays.copyOf(configSpec, configSpec.length + 1);
                last = configSpec.length - 1;
                configSpec[last] = 12344;
            }
            if (!GLContext.this.mEGL.eglChooseConfig(GLContext.this.mEGLDisplay, configSpec, configs, 1, configsCount)) {
                if (!GLContext.this.antialias) throw new IllegalArgumentException("eglChooseConfig failed " + GLUtils.getEGLErrorString((int)GLContext.this.mEGL.eglGetError()));
                if (view != null) {
                    view.contextAntialias = false;
                }
                configSpec = new int[]{12352, type, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, depthSize, 12326, stencilSize, 12344};
                boolean config = GLContext.this.mEGL.eglChooseConfig(GLContext.this.mEGLDisplay, configSpec, configs, 1, configsCount);
                if (config) {
                    GLContext.this.mEGLConfig = configs[0];
                }
            } else if (configsCount[0] > 0) {
                GLContext.this.mEGLConfig = configs[0];
            }
            if (GLContext.this.mEGLConfig == null) {
                throw new RuntimeException("eglConfig not initialized");
            }
            if (Utils.isEmulator()) {
                GLContext.this.mEGLContext = this.createGLContext(2, 0, GLContext.this.mEGLConfig);
            } else {
                if (view != null && view.glVersion > 2 && view.actualContextType.equals("webgl2") && (GLContext.this.mEGLContext == null || GLContext.this.mEGLContext == EGL10.EGL_NO_CONTEXT)) {
                    GLContext.this.mEGLContext = this.createGLContext(3, 0, GLContext.this.mEGLConfig);
                }
                if (GLContext.this.mEGLContext == null || GLContext.this.mEGLContext == EGL10.EGL_NO_CONTEXT) {
                    GLContext.this.mEGLContext = this.createGLContext(2, 0, GLContext.this.mEGLConfig);
                }
            }
            GLContext.this.mEGLSurface = GLContext.this.createSurface(GLContext.this.mEGLConfig, this.mSurface);
            if (GLContext.this.mEGLSurface == null || GLContext.this.mEGLSurface == EGL10.EGL_NO_SURFACE) {
                int error = GLContext.this.mEGL.eglGetError();
                throw new RuntimeException("eglCreateWindowSurface failed " + GLUtils.getEGLErrorString((int)error));
            }
            this.makeEGLContextCurrent();
            EGL14.eglSwapInterval((EGLDisplay)EGL14.eglGetCurrentDisplay(), (int)0);
            if (enableBufferPreservation && !(didEnableBufferPreservation = EGL14.eglSurfaceAttrib((EGLDisplay)EGL14.eglGetCurrentDisplay(), (android.opengl.EGLSurface)EGL14.eglGetCurrentSurface((int)12377), (int)12435, (int)12436)) && view != null) {
                view.contextPreserveDrawingBuffer = false;
            }
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            int bit = 16384;
            if (GLContext.this.depth) {
                GLES20.glClearDepthf((float)1.0f);
                bit |= 0x100;
            }
            if (GLContext.this.stencil) {
                GLES20.glClearStencil((int)0);
                bit |= 0x400;
            }
            GLES20.glClear((int)bit);
        }

        private void deInitEGL() {
            this.makeEGLContextCurrent();
            GLContext.this.destroySurface(GLContext.this.mEGLSurface);
            GLContext.this.mEGL.eglDestroyContext(GLContext.this.mEGLDisplay, GLContext.this.mEGLContext);
            GLContext.this.mEGL.eglTerminate(GLContext.this.mEGLDisplay);
        }

        private EGLContext createGLContext(int contextVersion, int minorVersion, EGLConfig eglConfig) {
            int[] attribs = new int[]{12440, contextVersion, 12539, minorVersion, 12344};
            return GLContext.this.mEGL.eglCreateContext(GLContext.this.mEGLDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, attribs);
        }

        private void makeEGLContextCurrent() {
            if (GLContext.this.mEGLContext.equals(GLContext.this.mEGL.eglGetCurrentContext()) && GLContext.this.mEGLSurface.equals(GLContext.this.mEGL.eglGetCurrentSurface(12377)) || !GLContext.this.makeCurrent(GLContext.this.mEGLSurface)) {
                // empty if block
            }
        }

        @Override
        public void run() {
            this.initEGL();
            GLView view = (GLView)((Object)GLContext.this.glView.get());
            if (view != null && view.startupLock != null) {
                CanvasView ref = (CanvasView)((Object)GLContext.this.reference.get());
                if (ref != null) {
                    this.type = ref.contextType;
                    this.makeEGLContextCurrent();
                    if (this.type == CanvasView.ContextType.CANVAS && ref.canvas == 0L) {
                        int[] frameBuffers = new int[1];
                        if (view.drawingBufferWidth == 0) {
                            view.drawingBufferWidth = view.getWidth();
                        }
                        if (view.drawingBufferHeight == 0) {
                            view.drawingBufferHeight = view.getHeight();
                        }
                        if (view.drawingBufferWidth == 0) {
                            view.drawingBufferWidth = 1;
                        }
                        if (view.drawingBufferHeight == 0) {
                            view.drawingBufferHeight = 1;
                        }
                        GLES20.glViewport((int)0, (int)0, (int)view.drawingBufferWidth, (int)view.drawingBufferHeight);
                        GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                        ref.canvas = CanvasView.nativeInit(false, frameBuffers[0], view.drawingBufferWidth, view.drawingBufferHeight, ref.scale, CanvasView.getDirection());
                    }
                }
                view.startupLock.countDown();
            }
            try {
                while (true) {
                    if (this.isPaused) {
                        continue;
                    }
                    this.makeEGLContextCurrent();
                    ((Runnable)GLContext.this.mQueue.take()).run();
                }
            }
            catch (InterruptedException e) {
                this.deInitEGL();
                return;
            }
        }
    }
}

