/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.text.TextUtilsCompat;
import com.github.triniwiz.canvas.CPUView;
import com.github.triniwiz.canvas.GLContext;
import com.github.triniwiz.canvas.GLView;
import com.github.triniwiz.canvas.TNSCanvasRenderingContext;
import com.github.triniwiz.canvas.TNSCanvasRenderingContext2D;
import com.github.triniwiz.canvas.TNSDOMMatrix;
import com.github.triniwiz.canvas.TNSTextDirection;
import com.github.triniwiz.canvas.TNSWebGL2RenderingContext;
import com.github.triniwiz.canvas.TNSWebGLRenderingContext;
import com.github.triniwiz.canvas.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00c5\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\n\u00c5\u0001\u00c6\u0001\u00c7\u0001\u00c8\u0001\u00c9\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0092\u0001\u001a\u00020\bH\u0002J\u0013\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u0095\u0001\u001a\u00020iH\u0016J\n\u0010\u0096\u0001\u001a\u00030\u0094\u0001H\u0004J\b\u0010\u0097\u0001\u001a\u00030\u0094\u0001J\u0012\u0010\u0098\u0001\u001a\u0004\u0018\u00010t2\u0007\u0010\u0099\u0001\u001a\u00020\u000eJ+\u0010\u0098\u0001\u001a\u0004\u0018\u00010t2\u0007\u0010\u0099\u0001\u001a\u00020\u000e2\u0017\u0010\u009a\u0001\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0005\u0012\u00030\u009c\u0001\u0018\u00010\u009b\u0001J#\u0010\u009d\u0001\u001a\u00030\u0094\u00012\u0017\u0010\u009a\u0001\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0005\u0012\u00030\u009c\u0001\u0018\u00010\u009b\u0001H\u0002J\u001a\u0010\u009e\u0001\u001a\u00030\u0094\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\n\u0010\u009f\u0001\u001a\u00030\u0094\u0001H\u0002J\u0010\u0010\u00a0\u0001\u001a\u00030\u0094\u0001H\u0000\u00a2\u0006\u0003\b\u00a1\u0001J \u0010\u00a2\u0001\u001a\u00030\u0094\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\n\u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u00a6\u0001H\u0016J\u0014\u0010\u00a7\u0001\u001a\u00030\u0094\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0014\u0010\u00a8\u0001\u001a\u00030\u0094\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0014\u0010\u00a9\u0001\u001a\u00030\u0094\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\u001e\u0010\u00aa\u0001\u001a\u00030\u0094\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\b\u0010\u00ab\u0001\u001a\u00030\u00a6\u0001H\u0016J\u0014\u0010\u00ac\u0001\u001a\u00030\u0094\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0014\u0010\u00ad\u0001\u001a\u00030\u0094\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\n\u0010\u00ae\u0001\u001a\u00030\u0094\u0001H\u0014J\n\u0010\u00af\u0001\u001a\u00030\u0094\u0001H\u0014J\b\u0010\u00b0\u0001\u001a\u00030\u0094\u0001J\b\u0010\u00b1\u0001\u001a\u00030\u0094\u0001J.\u0010\u00b2\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u00b3\u0001\u001a\u00020:2\u0007\u0010\u00b4\u0001\u001a\u00020:2\u0007\u0010\u00b5\u0001\u001a\u00020:2\u0007\u0010\u00b6\u0001\u001a\u00020:H\u0014J\u0014\u0010\u00b7\u0001\u001a\u00030\u0094\u00012\n\u0010\u00b8\u0001\u001a\u0005\u0018\u00010\u00b9\u0001J\b\u0010\u00ba\u0001\u001a\u00030\u0094\u0001J\u0012\u0010\u00bb\u0001\u001a\u00030\u0094\u00012\b\u0010\u00bc\u0001\u001a\u00030\u00bd\u0001J\b\u0010\u00be\u0001\u001a\u00030\u00bf\u0001J\n\u0010\u00c0\u0001\u001a\u0005\u0018\u00010\u00bf\u0001J!\u0010\u00c1\u0001\u001a\u0004\u0018\u00010\u000e2\t\b\u0002\u0010\u0099\u0001\u001a\u00020\u000e2\t\b\u0002\u0010\u00c2\u0001\u001a\u00020[H\u0007J\u0011\u0010\u00c3\u0001\u001a\u00030\u0094\u00012\u0007\u0010S\u001a\u00030\u00c4\u0001J\u001c\u0010\u00c3\u0001\u001a\u00030\u0094\u00012\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u000e2\u0007\u0010S\u001a\u00030\u00c4\u0001J%\u0010\u00c3\u0001\u001a\u00030\u0094\u00012\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u000e2\u0007\u0010\u00c2\u0001\u001a\u00020[2\u0007\u0010S\u001a\u00030\u00c4\u0001R\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u0010\u0006R\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010<R\u0012\u0010?\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010B\"\u0004\bG\u0010DR\u001a\u0010H\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010B\"\u0004\bJ\u0010DR\u001c\u0010K\u001a\u0004\u0018\u00010LX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR(\u0010S\u001a\u0004\u0018\u00010R2\b\u0010Q\u001a\u0004\u0018\u00010R@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0012\u0010X\u001a\u00020Y8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010Z\u001a\u00020[8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\\\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010]\u001a\u00020^8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010_\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010`\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010a\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010b\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010c\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010d\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010e\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010f\u001a\u00020:8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010h\u001a\u00020iX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\u000e\u0010n\u001a\u00020:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010o\u001a\u0004\u0018\u00010LX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010N\"\u0004\bq\u0010PR\u0012\u0010r\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010s\u001a\u0004\u0018\u00010tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010v\"\u0004\bw\u0010xR\u001a\u0010y\u001a\u00020[X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010{\"\u0004\b|\u0010}R \u0010~\u001a\u0004\u0018\u00010\u007fX\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001\"\u0006\b\u0082\u0001\u0010\u0083\u0001R\u001c\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0084\u0001\u0010B\"\u0005\b\u0085\u0001\u0010DR\"\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001\"\u0006\b\u008a\u0001\u0010\u008b\u0001R\"\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008e\u0001\u0010\u008f\u0001\"\u0006\b\u0090\u0001\u0010\u0091\u0001\u00a8\u0006\u00ca\u0001"}, d2={"Lcom/github/triniwiz/canvas/TNSCanvas;", "Landroid/widget/FrameLayout;", "Landroid/view/Choreographer$FrameCallback;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "useCpu", "", "(Landroid/content/Context;Z)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "actualContextType", "", "getActualContextType$canvas_release", "()Ljava/lang/String;", "setActualContextType$canvas_release", "(Ljava/lang/String;)V", "contextAlpha", "contextAntialias", "contextDepth", "contextDesynchronized", "contextFailIfMajorPerformanceCaveat", "contextPowerPreference", "contextPremultipliedAlpha", "contextPreserveDrawingBuffer", "contextStencil", "contextType", "Lcom/github/triniwiz/canvas/TNSCanvas$ContextType;", "getContextType$canvas_release", "()Lcom/github/triniwiz/canvas/TNSCanvas$ContextType;", "setContextType$canvas_release", "(Lcom/github/triniwiz/canvas/TNSCanvas$ContextType;)V", "contextXrCompatible", "cpuHandler", "Landroid/os/Handler;", "getCpuHandler", "()Landroid/os/Handler;", "setCpuHandler", "(Landroid/os/Handler;)V", "cpuHandlerThread", "Landroid/os/HandlerThread;", "getCpuHandlerThread", "()Landroid/os/HandlerThread;", "setCpuHandlerThread", "(Landroid/os/HandlerThread;)V", "cpuView", "Lcom/github/triniwiz/canvas/CPUView;", "getCpuView$canvas_release", "()Lcom/github/triniwiz/canvas/CPUView;", "setCpuView$canvas_release", "(Lcom/github/triniwiz/canvas/CPUView;)V", "ctx", "getCtx$canvas_release", "()Landroid/content/Context;", "setCtx$canvas_release", "drawingBufferHeight", "", "getDrawingBufferHeight", "()I", "drawingBufferWidth", "getDrawingBufferWidth", "glVersion", "isHandleInvalidationManually", "isHandleInvalidationManually$canvas_release", "()Z", "setHandleInvalidationManually$canvas_release", "(Z)V", "isPaused", "isPaused$canvas_release", "setPaused$canvas_release", "isWebGL", "isWebGL$canvas_release", "setWebGL$canvas_release", "lastSize", "Lcom/github/triniwiz/canvas/TNSCanvas$Size;", "getLastSize$canvas_release", "()Lcom/github/triniwiz/canvas/TNSCanvas$Size;", "setLastSize$canvas_release", "(Lcom/github/triniwiz/canvas/TNSCanvas$Size;)V", "value", "Lcom/github/triniwiz/canvas/TNSCanvas$Listener;", "listener", "getListener", "()Lcom/github/triniwiz/canvas/TNSCanvas$Listener;", "setListener", "(Lcom/github/triniwiz/canvas/TNSCanvas$Listener;)V", "mClearColor", "", "mClearDepth", "", "mClearStencil", "mColorMask", "", "mDepthMask", "mScissorEnabled", "mStencilFuncMask", "mStencilFuncMaskBack", "mStencilFuncRef", "mStencilFuncRefBack", "mStencilMask", "mStencilMaskBack", "mainHandler", "nativeContext", "", "getNativeContext$canvas_release", "()J", "setNativeContext$canvas_release", "(J)V", "needRenderRequest", "newSize", "getNewSize$canvas_release", "setNewSize$canvas_release", "pendingInvalidate", "renderingContext2d", "Lcom/github/triniwiz/canvas/TNSCanvasRenderingContext;", "getRenderingContext2d$canvas_release", "()Lcom/github/triniwiz/canvas/TNSCanvasRenderingContext;", "setRenderingContext2d$canvas_release", "(Lcom/github/triniwiz/canvas/TNSCanvasRenderingContext;)V", "scale", "getScale$canvas_release", "()F", "setScale$canvas_release", "(F)V", "surface", "Lcom/github/triniwiz/canvas/GLView;", "getSurface$canvas_release", "()Lcom/github/triniwiz/canvas/GLView;", "setSurface$canvas_release", "(Lcom/github/triniwiz/canvas/GLView;)V", "getUseCpu$canvas_release", "setUseCpu$canvas_release", "webGL2RenderingContext", "Lcom/github/triniwiz/canvas/TNSWebGL2RenderingContext;", "getWebGL2RenderingContext$canvas_release", "()Lcom/github/triniwiz/canvas/TNSWebGL2RenderingContext;", "setWebGL2RenderingContext$canvas_release", "(Lcom/github/triniwiz/canvas/TNSWebGL2RenderingContext;)V", "webGLRenderingContext", "Lcom/github/triniwiz/canvas/TNSWebGLRenderingContext;", "getWebGLRenderingContext$canvas_release", "()Lcom/github/triniwiz/canvas/TNSWebGLRenderingContext;", "setWebGLRenderingContext$canvas_release", "(Lcom/github/triniwiz/canvas/TNSWebGLRenderingContext;)V", "detectOpenGLES30", "doFrame", "", "frameTimeNanos", "finalize", "flush", "getContext", "type", "contextAttributes", "", "", "handleAttributes", "init", "initCPUThread", "initCanvas", "initCanvas$canvas_release", "onActivityCreated", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onAttachedToWindow", "onDetachedFromWindow", "onPause", "onResume", "onSizeChanged", "w", "h", "oldw", "oldh", "queueEvent", "runnable", "Ljava/lang/Runnable;", "resizeViewPort", "setupActivityHandler", "app", "Landroid/app/Application;", "snapshot", "", "toData", "toDataURL", "quality", "toDataURLAsync", "Lcom/github/triniwiz/canvas/TNSCanvas$DataURLListener;", "Companion", "ContextType", "DataURLListener", "Listener", "Size", "canvas_release"})
public final class TNSCanvas
extends FrameLayout
implements Choreographer.FrameCallback,
Application.ActivityLifecycleCallbacks {
    private long nativeContext;
    @Nullable
    private GLView surface;
    @Nullable
    private CPUView cpuView;
    private boolean isHandleInvalidationManually;
    @Nullable
    private TNSCanvasRenderingContext renderingContext2d;
    private float scale;
    @Nullable
    private Context ctx;
    @JvmField
    public boolean pendingInvalidate;
    @NotNull
    private ContextType contextType;
    @NotNull
    private String actualContextType;
    private boolean useCpu;
    @JvmField
    public boolean contextAlpha;
    @JvmField
    public boolean contextAntialias;
    @JvmField
    public boolean contextDepth;
    @JvmField
    public boolean contextFailIfMajorPerformanceCaveat;
    @JvmField
    @Nullable
    public String contextPowerPreference;
    @JvmField
    public boolean contextPremultipliedAlpha;
    @JvmField
    public boolean contextPreserveDrawingBuffer;
    @JvmField
    public boolean contextStencil;
    @JvmField
    public boolean contextDesynchronized;
    @JvmField
    public boolean contextXrCompatible;
    @JvmField
    public int mClearStencil;
    @JvmField
    @NotNull
    public float[] mClearColor;
    @JvmField
    public boolean mScissorEnabled;
    @JvmField
    public float mClearDepth;
    @JvmField
    @NotNull
    public boolean[] mColorMask;
    @JvmField
    public int mStencilMask;
    @JvmField
    public int mStencilMaskBack;
    @JvmField
    public int mStencilFuncRef;
    @JvmField
    public int mStencilFuncRefBack;
    @JvmField
    public int mStencilFuncMask;
    @JvmField
    public int mStencilFuncMaskBack;
    @JvmField
    public boolean mDepthMask;
    @JvmField
    public int glVersion;
    private final Handler mainHandler;
    @Nullable
    private Handler cpuHandler;
    @Nullable
    private HandlerThread cpuHandlerThread;
    @Nullable
    private TNSWebGLRenderingContext webGLRenderingContext;
    @Nullable
    private TNSWebGL2RenderingContext webGL2RenderingContext;
    private int needRenderRequest;
    private boolean isPaused;
    @Nullable
    private Listener listener;
    private boolean isWebGL;
    @Nullable
    private Size lastSize;
    @Nullable
    private Size newSize;
    @NotNull
    private static ConcurrentHashMap<?, ?> views;
    public static final long ONE_MILLISECOND_NS = 1000000L;
    public static final long ONE_S_IN_NS = 1000000000L;
    private static long lastCall;
    private static boolean isLibraryLoaded;
    @NotNull
    public static final String TAG = "CanvasView";
    @NotNull
    public static final Companion Companion;

    public final long getNativeContext$canvas_release() {
        return this.nativeContext;
    }

    public final void setNativeContext$canvas_release(long l) {
        this.nativeContext = l;
    }

    @Nullable
    public final GLView getSurface$canvas_release() {
        return this.surface;
    }

    public final void setSurface$canvas_release(@Nullable GLView gLView) {
        this.surface = gLView;
    }

    @Nullable
    public final CPUView getCpuView$canvas_release() {
        return this.cpuView;
    }

    public final void setCpuView$canvas_release(@Nullable CPUView cPUView) {
        this.cpuView = cPUView;
    }

    public final boolean isHandleInvalidationManually$canvas_release() {
        return this.isHandleInvalidationManually;
    }

    public final void setHandleInvalidationManually$canvas_release(boolean bl) {
        this.isHandleInvalidationManually = bl;
    }

    @Nullable
    public final TNSCanvasRenderingContext getRenderingContext2d$canvas_release() {
        return this.renderingContext2d;
    }

    public final void setRenderingContext2d$canvas_release(@Nullable TNSCanvasRenderingContext tNSCanvasRenderingContext) {
        this.renderingContext2d = tNSCanvasRenderingContext;
    }

    public final float getScale$canvas_release() {
        return this.scale;
    }

    public final void setScale$canvas_release(float f) {
        this.scale = f;
    }

    @Nullable
    public final Context getCtx$canvas_release() {
        return this.ctx;
    }

    public final void setCtx$canvas_release(@Nullable Context context) {
        this.ctx = context;
    }

    @NotNull
    public final ContextType getContextType$canvas_release() {
        return this.contextType;
    }

    public final void setContextType$canvas_release(@NotNull ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"<set-?>");
        this.contextType = contextType;
    }

    @NotNull
    public final String getActualContextType$canvas_release() {
        return this.actualContextType;
    }

    public final void setActualContextType$canvas_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.actualContextType = string;
    }

    public final boolean getUseCpu$canvas_release() {
        return this.useCpu;
    }

    public final void setUseCpu$canvas_release(boolean bl) {
        this.useCpu = bl;
    }

    public void doFrame(long frameTimeNanos) {
        if (!this.isHandleInvalidationManually && this.pendingInvalidate) {
            this.flush();
        }
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    private final void init(Context context, boolean useCpu) {
        if (this.isInEditMode()) {
            return;
        }
        this.useCpu = useCpu;
        if (!isLibraryLoaded) {
            System.loadLibrary("canvasnative");
            isLibraryLoaded = true;
        }
        this.setBackgroundColor(0);
        GLView gLView = this.surface = new GLView(context);
        Intrinsics.checkNotNull((Object)((Object)gLView));
        Intrinsics.checkNotNull((Object)gLView.getGLContext());
        gLView.getGLContext().reference = new WeakReference<TNSCanvas>(this);
        this.ctx = context;
        this.glVersion = this.detectOpenGLES30() && !Utils.INSTANCE.isEmulator() ? 3 : 2;
        GLView gLView2 = this.surface;
        Intrinsics.checkNotNull((Object)((Object)gLView2));
        gLView2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (useCpu) {
            CPUView cPUView = this.cpuView = new CPUView(context, null, 0, 6, null);
            Intrinsics.checkNotNull((Object)((Object)cPUView));
            cPUView.setCanvasView$canvas_release(new WeakReference<TNSCanvas>(this));
            CPUView cPUView2 = this.cpuView;
            Intrinsics.checkNotNull((Object)((Object)cPUView2));
            cPUView2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.initCPUThread();
            this.addView(this.cpuView);
        } else {
            this.addView((View)this.surface);
        }
    }

    private final void initCPUThread() {
        HandlerThread handlerThread = this.cpuHandlerThread = new HandlerThread("CanvasViewCpuThread");
        Intrinsics.checkNotNull((Object)handlerThread);
        handlerThread.start();
        HandlerThread handlerThread2 = this.cpuHandlerThread;
        Intrinsics.checkNotNull((Object)handlerThread2);
        this.cpuHandler = new Handler(handlerThread2.getLooper());
    }

    public final int getDrawingBufferWidth() {
        int n;
        if (this.useCpu) {
            CPUView cPUView = this.cpuView;
            Intrinsics.checkNotNull((Object)((Object)cPUView));
            n = cPUView.getWidth();
        } else {
            GLView gLView = this.surface;
            Intrinsics.checkNotNull((Object)((Object)gLView));
            n = gLView.drawingBufferWidth;
        }
        return n;
    }

    public final int getDrawingBufferHeight() {
        int n;
        if (this.useCpu) {
            CPUView cPUView = this.cpuView;
            Intrinsics.checkNotNull((Object)((Object)cPUView));
            n = cPUView.getHeight();
        } else {
            GLView gLView = this.surface;
            Intrinsics.checkNotNull((Object)((Object)gLView));
            n = gLView.drawingBufferHeight;
        }
        return n;
    }

    private final boolean detectOpenGLES30() {
        boolean bl;
        ActivityManager am;
        Object object = this.getContext().getSystemService("activity");
        if (!(object instanceof ActivityManager)) {
            object = null;
        }
        ActivityManager activityManager = am = (ActivityManager)object;
        if (activityManager != null) {
            ActivityManager activityManager2 = activityManager;
            boolean bl2 = false;
            boolean bl3 = false;
            ActivityManager it = activityManager2;
            boolean bl4 = false;
            bl = it.getDeviceConfigurationInfo().reqGlEsVersion >= 196608;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void onPause() {
        block0: {
            Object object = this.surface;
            if (object == null || (object = object.getGLContext()) == null) break block0;
            ((GLContext)object).onPause();
        }
    }

    public final void onResume() {
        block0: {
            Object object = this.surface;
            if (object == null || (object = object.getGLContext()) == null) break block0;
            ((GLContext)object).onResume();
        }
    }

    protected final synchronized void finalize() throws Throwable {
        if (this.nativeContext != 0L) {
            TNSCanvas.Companion.nativeDestroyContext(this.nativeContext);
            this.nativeContext = 0L;
        }
    }

    @Nullable
    public final Handler getCpuHandler() {
        return this.cpuHandler;
    }

    public final void setCpuHandler(@Nullable Handler handler) {
        this.cpuHandler = handler;
    }

    @Nullable
    public final HandlerThread getCpuHandlerThread() {
        return this.cpuHandlerThread;
    }

    public final void setCpuHandlerThread(@Nullable HandlerThread handlerThread) {
        this.cpuHandlerThread = handlerThread;
    }

    public final void queueEvent(@Nullable Runnable runnable) {
        block4: {
            Runnable it;
            block5: {
                block7: {
                    block6: {
                        Runnable runnable2 = runnable;
                        if (runnable2 == null) break block4;
                        Runnable runnable3 = runnable2;
                        boolean bl = false;
                        boolean bl2 = false;
                        it = runnable3;
                        boolean bl3 = false;
                        if (!this.useCpu) break block5;
                        HandlerThread handlerThread = this.cpuHandlerThread;
                        Intrinsics.checkNotNull((Object)handlerThread);
                        if (!handlerThread.isAlive()) break block6;
                        HandlerThread handlerThread2 = this.cpuHandlerThread;
                        Intrinsics.checkNotNull((Object)handlerThread2);
                        if (!handlerThread2.isInterrupted()) break block7;
                    }
                    this.cpuHandlerThread = null;
                    this.cpuHandler = null;
                    this.initCPUThread();
                }
                Handler handler = this.cpuHandler;
                if (handler == null) break block4;
                handler.post(it);
                break block4;
            }
            GLView gLView = this.surface;
            if (gLView == null) break block4;
            gLView.queueEvent(it);
        }
    }

    public final void setupActivityHandler(@NotNull Application app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @Nullable
    public final byte[] toData() {
        if (this.contextType == ContextType.CANVAS) {
            CountDownLatch lock = new CountDownLatch(1);
            byte[][] data = new byte[1][];
            this.queueEvent(new Runnable(this, data, lock){
                final /* synthetic */ TNSCanvas this$0;
                final /* synthetic */ byte[][] $data;
                final /* synthetic */ CountDownLatch $lock;

                public final void run() {
                    this.$data[0] = com.github.triniwiz.canvas.TNSCanvas$Companion.access$nativeToData(TNSCanvas.Companion, this.this$0.getNativeContext$canvas_release());
                    this.$lock.countDown();
                }
                {
                    this.this$0 = tNSCanvas;
                    this.$data = byArray;
                    this.$lock = countDownLatch;
                }
            });
            try {
                lock.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return data[0];
        }
        if (this.contextType == ContextType.WEBGL) {
            Bitmap bm;
            GLView gLView = this.surface;
            Intrinsics.checkNotNull((Object)((Object)gLView));
            Bitmap bitmap = bm = gLView.getBitmap(this.getWidth(), this.getHeight());
            Intrinsics.checkNotNull((Object)bitmap);
            byte[] data = new byte[bitmap.getWidth() * bm.getHeight() * 4];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            bm.copyPixelsToBuffer((Buffer)buffer);
            return data;
        }
        return new byte[0];
    }

    @NotNull
    public final byte[] snapshot() {
        if (this.contextType == ContextType.CANVAS) {
            CountDownLatch lock = new CountDownLatch(1);
            ArrayList ss = new ArrayList();
            this.queueEvent(new Runnable(this, ss, lock){
                final /* synthetic */ TNSCanvas this$0;
                final /* synthetic */ ArrayList $ss;
                final /* synthetic */ CountDownLatch $lock;

                public final void run() {
                    this.$ss.add(com.github.triniwiz.canvas.TNSCanvas$Companion.access$nativeSnapshotCanvas(TNSCanvas.Companion, this.this$0.getNativeContext$canvas_release()));
                    this.$lock.countDown();
                }
                {
                    this.this$0 = tNSCanvas;
                    this.$ss = arrayList;
                    this.$lock = countDownLatch;
                }
            });
            try {
                lock.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object e = ss.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"ss[0]");
            return (byte[])e;
        }
        if (this.contextType == ContextType.WEBGL) {
            GLView gLView = this.surface;
            Intrinsics.checkNotNull((Object)((Object)gLView));
            Bitmap bm = gLView.getBitmap(this.getWidth(), this.getHeight());
            return Utils.INSTANCE.getBytesFromBitmap(bm);
        }
        return new byte[0];
    }

    public final void toDataURLAsync(@NotNull DataURLListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.toDataURLAsync("image/png", listener);
    }

    public final void toDataURLAsync(@Nullable String type, @NotNull DataURLListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.toDataURLAsync(type, 0.92f, listener);
    }

    public final void toDataURLAsync(@Nullable String type, float quality, @NotNull DataURLListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.queueEvent(new Runnable(this, listener, type, quality){
            final /* synthetic */ TNSCanvas this$0;
            final /* synthetic */ DataURLListener $listener;
            final /* synthetic */ String $type;
            final /* synthetic */ float $quality;

            public final void run() {
                this.$listener.onResult(com.github.triniwiz.canvas.TNSCanvas$Companion.access$nativeDataURL(TNSCanvas.Companion, this.this$0.getNativeContext$canvas_release(), this.$type, this.$quality));
            }
            {
                this.this$0 = tNSCanvas;
                this.$listener = dataURLListener;
                this.$type = string;
                this.$quality = f;
            }
        });
    }

    @JvmOverloads
    @Nullable
    public final String toDataURL(@NotNull String type, float quality) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.contextType == ContextType.WEBGL) {
            GLView gLView = this.surface;
            Intrinsics.checkNotNull((Object)((Object)gLView));
            Bitmap bm = gLView.getBitmap(this.getWidth(), this.getHeight());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            String dataType = "image/png";
            switch (type) {
                case "image/jpeg": {
                    dataType = "image/jpeg";
                    break;
                }
                case "image/jpg": {
                    dataType = "image/jpg";
                    break;
                }
            }
            if (bm != null) {
                if (Intrinsics.areEqual((Object)type, (Object)"image/jpeg") || Intrinsics.areEqual((Object)type, (Object)"image/jpg")) {
                    bm.compress(Bitmap.CompressFormat.JPEG, (int)(quality * (float)100), (OutputStream)os);
                } else {
                    bm.compress(Bitmap.CompressFormat.PNG, (int)(quality * (float)100), (OutputStream)os);
                }
            }
            String string = StringCompanionObject.INSTANCE;
            String string2 = "data:%s;base64,%s";
            Object[] objectArray = new Object[]{dataType, Base64.encodeToString((byte[])os.toByteArray(), (int)2)};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }
        CountDownLatch lock = new CountDownLatch(1);
        String[] data = new String[1];
        this.queueEvent(new Runnable(this, data, type, quality, lock){
            final /* synthetic */ TNSCanvas this$0;
            final /* synthetic */ String[] $data;
            final /* synthetic */ String $type;
            final /* synthetic */ float $quality;
            final /* synthetic */ CountDownLatch $lock;

            public final void run() {
                this.$data[0] = com.github.triniwiz.canvas.TNSCanvas$Companion.access$nativeDataURL(TNSCanvas.Companion, this.this$0.getNativeContext$canvas_release(), this.$type, this.$quality);
                this.$lock.countDown();
            }
            {
                this.this$0 = tNSCanvas;
                this.$data = stringArray;
                this.$type = string;
                this.$quality = f;
                this.$lock = countDownLatch;
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return data[0];
    }

    public static /* synthetic */ String toDataURL$default(TNSCanvas tNSCanvas, String string, float f, int n, Object object) {
        if ((n & 1) != 0) {
            string = "image/png";
        }
        if ((n & 2) != 0) {
            f = 0.92f;
        }
        return tNSCanvas.toDataURL(string, f);
    }

    @JvmOverloads
    @Nullable
    public final String toDataURL(@NotNull String type) {
        return TNSCanvas.toDataURL$default(this, type, 0.0f, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final String toDataURL() {
        return TNSCanvas.toDataURL$default(this, null, 0.0f, 3, null);
    }

    @Nullable
    public final TNSWebGLRenderingContext getWebGLRenderingContext$canvas_release() {
        return this.webGLRenderingContext;
    }

    public final void setWebGLRenderingContext$canvas_release(@Nullable TNSWebGLRenderingContext tNSWebGLRenderingContext) {
        this.webGLRenderingContext = tNSWebGLRenderingContext;
    }

    @Nullable
    public final TNSWebGL2RenderingContext getWebGL2RenderingContext$canvas_release() {
        return this.webGL2RenderingContext;
    }

    public final void setWebGL2RenderingContext$canvas_release(@Nullable TNSWebGL2RenderingContext tNSWebGL2RenderingContext) {
        this.webGL2RenderingContext = tNSWebGL2RenderingContext;
    }

    public final void resizeViewPort() {
        this.queueEvent(new Runnable(this){
            final /* synthetic */ TNSCanvas this$0;

            public final void run() {
                GLES20.glViewport((int)0, (int)0, (int)this.this$0.getWidth(), (int)this.this$0.getHeight());
            }
            {
                this.this$0 = tNSCanvas;
            }
        });
    }

    public final void initCanvas$canvas_release() {
        block7: {
            int height;
            int width;
            block9: {
                block8: {
                    if (this.surface == null || this.nativeContext != 0L) break block7;
                    GLView gLView = this.surface;
                    Intrinsics.checkNotNull((Object)((Object)gLView));
                    width = gLView.getWidth();
                    GLView gLView2 = this.surface;
                    Intrinsics.checkNotNull((Object)((Object)gLView2));
                    height = gLView2.getHeight();
                    GLView gLView3 = this.surface;
                    Intrinsics.checkNotNull((Object)((Object)gLView3));
                    ViewGroup.LayoutParams params = gLView3.getLayoutParams();
                    if (width == 0 && params != null) {
                        width = params.width;
                        ++this.needRenderRequest;
                    }
                    if (height == 0 && params != null) {
                        height = params.height;
                        ++this.needRenderRequest;
                    }
                    if (width == 0) {
                        width = 1;
                        ++this.needRenderRequest;
                    }
                    if (height == 0) {
                        height = 1;
                        ++this.needRenderRequest;
                    }
                    if (this.newSize == null) break block8;
                    Size size = this.newSize;
                    Intrinsics.checkNotNull((Object)size);
                    if (size.getWidth() != 0) break block9;
                    Size size2 = this.newSize;
                    Intrinsics.checkNotNull((Object)size2);
                    if (size2.getHeight() != 0) break block9;
                }
                this.newSize = new Size(width, height);
            }
            int finalWidth = width;
            int finalHeight = height;
            GLView gLView = this.surface;
            Intrinsics.checkNotNull((Object)((Object)gLView));
            gLView.queueEvent(new Runnable(this, finalWidth, finalHeight){
                final /* synthetic */ TNSCanvas this$0;
                final /* synthetic */ int $finalWidth;
                final /* synthetic */ int $finalHeight;

                public final void run() {
                    if (this.this$0.getNativeContext$canvas_release() == 0L && this.$finalWidth > 0 && this.$finalHeight > 0) {
                        int[] frameBuffers = new int[1];
                        GLES20.glViewport((int)0, (int)0, (int)this.$finalWidth, (int)this.$finalHeight);
                        GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                        int samples = 0;
                        if (this.this$0.contextAntialias) {
                            samples = 4;
                        }
                        Resources resources = this.this$0.getResources();
                        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
                        DisplayMetrics metrics = resources.getDisplayMetrics();
                        this.this$0.setNativeContext$canvas_release(TNSCanvas.Companion.nativeInitContext(this.$finalWidth, this.$finalHeight, this.this$0.getScale$canvas_release(), frameBuffers[0], samples, true, -16777216, metrics.density, TNSCanvas.Companion.getDirection$canvas_release().toNative()));
                    }
                }
                {
                    this.this$0 = tNSCanvas;
                    this.$finalWidth = n;
                    this.$finalHeight = n2;
                }
            });
        }
    }

    @Nullable
    public final TNSCanvasRenderingContext getContext(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        HashMap attributes = new HashMap();
        if (Intrinsics.areEqual((Object)type, (Object)"2d")) {
            ((Map)attributes).put("alpha", true);
            ((Map)attributes).put("desynchronized", false);
        } else if (StringsKt.contains$default((CharSequence)type, (CharSequence)"webgl", (boolean)false, (int)2, null)) {
            ((Map)attributes).put("alpha", true);
            ((Map)attributes).put("depth", true);
            ((Map)attributes).put("antialias", true);
            ((Map)attributes).put("failIfMajorPerformanceCaveat", false);
            ((Map)attributes).put("powerPreference", "default");
            ((Map)attributes).put("premultipliedAlpha", true);
            ((Map)attributes).put("preserveDrawingBuffer", false);
            ((Map)attributes).put("stencil", false);
            ((Map)attributes).put("xrCompatible", false);
            ((Map)attributes).put("desynchronized", false);
        }
        return this.getContext(type, attributes);
    }

    private final void handleAttributes(Map<String, ? extends Object> contextAttributes) {
        if (contextAttributes != null) {
            Set<String> keys = contextAttributes.keySet();
            for (String key : keys) {
                Object value = contextAttributes.get(key);
                switch (key) {
                    case "alpha": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextAlpha = (Boolean)object;
                        break;
                    }
                    case "antialias": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextAntialias = (Boolean)object;
                        break;
                    }
                    case "depth": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextDepth = (Boolean)object;
                        break;
                    }
                    case "failIfMajorPerformanceCaveat": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextFailIfMajorPerformanceCaveat = (Boolean)object;
                        break;
                    }
                    case "premultipliedAlpha": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextPremultipliedAlpha = (Boolean)object;
                        break;
                    }
                    case "preserveDrawingBuffer": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextPreserveDrawingBuffer = (Boolean)object;
                        break;
                    }
                    case "stencil": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextStencil = (Boolean)object;
                        break;
                    }
                    case "xrCompatible": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextXrCompatible = (Boolean)object;
                        break;
                    }
                    case "desynchronized": {
                        Object object = value;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        this.contextDesynchronized = (Boolean)object;
                        break;
                    }
                    case "powerPreference": {
                        this.contextPowerPreference = (String)value;
                        break;
                    }
                }
            }
        }
    }

    @Nullable
    public final TNSCanvasRenderingContext getContext(@NotNull String type, @Nullable Map<String, ? extends Object> contextAttributes) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.handleAttributes(contextAttributes);
        if (Intrinsics.areEqual((Object)type, (Object)"2d") || Intrinsics.areEqual((Object)type, (Object)"experimental-webgl") || Intrinsics.areEqual((Object)type, (Object)"webgl") || Intrinsics.areEqual((Object)type, (Object)"webgl2") && Build.VERSION.SDK_INT >= 18) {
            this.mainHandler.post(new Runnable(this){
                final /* synthetic */ TNSCanvas this$0;

                public final void run() {
                    block0: {
                        GLView gLView = this.this$0.getSurface$canvas_release();
                        if (gLView == null) break block0;
                        GLView gLView2 = gLView;
                        boolean bl = false;
                        boolean bl2 = false;
                        GLView $this$apply = gLView2;
                        boolean bl3 = false;
                        $this$apply.setOpaque(!this.this$0.contextAlpha);
                    }
                }
                {
                    this.this$0 = tNSCanvas;
                }
            });
            if (Intrinsics.areEqual((Object)type, (Object)"2d")) {
                this.contextType = ContextType.CANVAS;
            }
            if (!this.useCpu && this.renderingContext2d == null && this.webGLRenderingContext == null && this.webGL2RenderingContext == null) {
                GLView gLView = this.surface;
                if (gLView != null) {
                    gLView.setupContext();
                }
            }
        }
        switch (type) {
            case "2d": {
                this.actualContextType = "2d";
                if (this.renderingContext2d == null) {
                    this.renderingContext2d = new TNSCanvasRenderingContext2D(this);
                }
                this.contextType = ContextType.CANVAS;
                return this.renderingContext2d;
            }
            case "webgl": 
            case "experimental-webgl": {
                this.actualContextType = "webgl";
                if (this.webGLRenderingContext == null) {
                    this.webGLRenderingContext = new TNSWebGLRenderingContext(this);
                }
                this.contextType = ContextType.WEBGL;
                return this.webGLRenderingContext;
            }
            case "webgl2": {
                if (this.webGL2RenderingContext == null) {
                    if (Build.VERSION.SDK_INT >= 18) {
                        this.actualContextType = "webgl";
                        this.webGL2RenderingContext = new TNSWebGL2RenderingContext(this);
                        this.isWebGL = true;
                        this.contextType = ContextType.WEBGL;
                    } else {
                        this.isWebGL = false;
                        this.contextType = ContextType.NONE;
                        return null;
                    }
                }
                return this.webGL2RenderingContext;
            }
        }
        this.contextType = ContextType.NONE;
        return null;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        block0: {
            GLView gLView = this.surface;
            if (gLView == null) break block0;
            gLView.resize(w, h);
        }
    }

    public final boolean isPaused$canvas_release() {
        return this.isPaused;
    }

    public final void setPaused$canvas_release(boolean bl) {
        this.isPaused = bl;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isPaused = true;
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isPaused = false;
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    @Nullable
    public final Listener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable Listener value) {
        block0: {
            this.listener = value;
            GLView gLView = this.surface;
            if (gLView == null) break block0;
            gLView.setListener(this.listener);
        }
    }

    public final boolean isWebGL$canvas_release() {
        return this.isWebGL;
    }

    public final void setWebGL$canvas_release(boolean bl) {
        this.isWebGL = bl;
    }

    @Nullable
    public final Size getLastSize$canvas_release() {
        return this.lastSize;
    }

    public final void setLastSize$canvas_release(@Nullable Size size) {
        this.lastSize = size;
    }

    @Nullable
    public final Size getNewSize$canvas_release() {
        return this.newSize;
    }

    public final void setNewSize$canvas_release(@Nullable Size size) {
        this.newSize = size;
    }

    public final void flush() {
        block1: {
            block0: {
                if (!this.useCpu) break block0;
                CPUView cPUView = this.cpuView;
                if (cPUView == null) break block1;
                cPUView.flush();
                break block1;
            }
            GLView gLView = this.surface;
            if (gLView == null) break block1;
            gLView.flush();
        }
    }

    public TNSCanvas(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null);
        this.scale = 1.0f;
        this.contextType = ContextType.NONE;
        this.actualContextType = "";
        this.contextAlpha = true;
        this.contextAntialias = true;
        this.contextDepth = true;
        this.contextPowerPreference = "default";
        this.contextPremultipliedAlpha = true;
        this.mClearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.mClearDepth = 1.0f;
        this.mColorMask = new boolean[]{true, true, true, true};
        this.mStencilMask = (int)0xFFFFFFFFL;
        this.mStencilMaskBack = (int)0xFFFFFFFFL;
        this.mStencilFuncMask = (int)0xFFFFFFFFL;
        this.mStencilFuncMaskBack = (int)0xFFFFFFFFL;
        this.mDepthMask = true;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.init(context, false);
    }

    public TNSCanvas(@NotNull Context context, boolean useCpu) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null);
        this.scale = 1.0f;
        this.contextType = ContextType.NONE;
        this.actualContextType = "";
        this.contextAlpha = true;
        this.contextAntialias = true;
        this.contextDepth = true;
        this.contextPowerPreference = "default";
        this.contextPremultipliedAlpha = true;
        this.mClearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.mClearDepth = 1.0f;
        this.mColorMask = new boolean[]{true, true, true, true};
        this.mStencilMask = (int)0xFFFFFFFFL;
        this.mStencilMaskBack = (int)0xFFFFFFFFL;
        this.mStencilFuncMask = (int)0xFFFFFFFFL;
        this.mStencilFuncMaskBack = (int)0xFFFFFFFFL;
        this.mDepthMask = true;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.init(context, useCpu);
    }

    public TNSCanvas(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.scale = 1.0f;
        this.contextType = ContextType.NONE;
        this.actualContextType = "";
        this.contextAlpha = true;
        this.contextAntialias = true;
        this.contextDepth = true;
        this.contextPowerPreference = "default";
        this.contextPremultipliedAlpha = true;
        this.mClearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.mClearDepth = 1.0f;
        this.mColorMask = new boolean[]{true, true, true, true};
        this.mStencilMask = (int)0xFFFFFFFFL;
        this.mStencilMaskBack = (int)0xFFFFFFFFL;
        this.mStencilFuncMask = (int)0xFFFFFFFFL;
        this.mStencilFuncMaskBack = (int)0xFFFFFFFFL;
        this.mDepthMask = true;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.init(context, false);
    }

    static {
        Companion = new Companion(null);
        views = new ConcurrentHashMap();
    }

    @JvmStatic
    public static final native long nativeInitContext(float var0, float var1, float var2, int var3, int var4, boolean var5, int var6, float var7, int var8);

    @JvmStatic
    public static final native long nativeInitContextWithCustomSurface(float var0, float var1, float var2, boolean var3, int var4, float var5, int var6);

    @JvmStatic
    public static final native void nativeResizeCustomSurface(long var0, float var2, float var3, float var4, boolean var5, int var6);

    @JvmStatic
    public static final native void nativeResizeSurface(long var0, float var2, float var3, float var4, int var5, int var6, boolean var7, float var8);

    @JvmStatic
    private static final native void nativeDestroyContext(long var0);

    @JvmStatic
    public static final native void nativeFlush(long var0);

    @JvmStatic
    public static final native void nativeCustomWithBitmapFlush(long var0, @NotNull Bitmap var2);

    @JvmStatic
    private static final native String nativeDataURL(long var0, String var2, float var3);

    @JvmStatic
    private static final native byte[] nativeToData(long var0);

    @JvmStatic
    private static final native byte[] nativeSnapshotCanvas(long var0);

    @JvmStatic
    @NotNull
    public static final TNSDOMMatrix createSVGMatrix() {
        return Companion.createSVGMatrix();
    }

    @NotNull
    public static final TNSTextDirection getDirection$canvas_release() {
        return Companion.getDirection$canvas_release();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/github/triniwiz/canvas/TNSCanvas$DataURLListener;", "", "onResult", "", "data", "", "canvas_release"})
    public static interface DataURLListener {
        public void onResult(@Nullable String var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/triniwiz/canvas/TNSCanvas$ContextType;", "", "(Ljava/lang/String;I)V", "NONE", "CANVAS", "WEBGL", "canvas_release"})
    public static final class ContextType
    extends Enum<ContextType> {
        public static final /* enum */ ContextType NONE;
        public static final /* enum */ ContextType CANVAS;
        public static final /* enum */ ContextType WEBGL;
        private static final /* synthetic */ ContextType[] $VALUES;

        static {
            ContextType[] contextTypeArray = new ContextType[3];
            ContextType[] contextTypeArray2 = contextTypeArray;
            contextTypeArray[0] = NONE = new ContextType();
            contextTypeArray[1] = CANVAS = new ContextType();
            contextTypeArray[2] = WEBGL = new ContextType();
            $VALUES = contextTypeArray;
        }

        public static ContextType[] values() {
            return (ContextType[])$VALUES.clone();
        }

        public static ContextType valueOf(String string) {
            return Enum.valueOf(ContextType.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/github/triniwiz/canvas/TNSCanvas$Listener;", "", "contextReady", "", "canvas_release"})
    public static interface Listener {
        public void contextReady();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/github/triniwiz/canvas/TNSCanvas$Size;", "", "width", "", "height", "(II)V", "getHeight", "()I", "setHeight", "(I)V", "getWidth", "setWidth", "canvas_release"})
    public static final class Size {
        private int width;
        private int height;

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u0019\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0087 J%\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u00042\b\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020(H\u0083 J\u0011\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0083 J\u0011\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0087 JQ\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u00020(2\u0006\u0010\b\u001a\u000200H\u0087 JA\u00105\u001a\u00020\u00042\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u00020(2\u0006\u0010\b\u001a\u000200H\u0087 J9\u00106\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u00102\u001a\u00020\u000e2\u0006\u00104\u001a\u000200H\u0087 JI\u00107\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u000e2\u0006\u00104\u001a\u00020(H\u0087 J\u0011\u00108\u001a\u0002092\u0006\u0010\"\u001a\u00020\u0004H\u0083 J\u0013\u0010:\u001a\u0004\u0018\u0001092\u0006\u0010\"\u001a\u00020\u0004H\u0083 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006;"}, d2={"Lcom/github/triniwiz/canvas/TNSCanvas$Companion;", "", "()V", "ONE_MILLISECOND_NS", "", "ONE_S_IN_NS", "TAG", "", "direction", "Lcom/github/triniwiz/canvas/TNSTextDirection;", "getDirection$canvas_release$annotations", "getDirection$canvas_release", "()Lcom/github/triniwiz/canvas/TNSTextDirection;", "isLibraryLoaded", "", "isLibraryLoaded$canvas_release", "()Z", "setLibraryLoaded$canvas_release", "(Z)V", "lastCall", "getLastCall$canvas_release", "()J", "setLastCall$canvas_release", "(J)V", "views", "Ljava/util/concurrent/ConcurrentHashMap;", "getViews", "()Ljava/util/concurrent/ConcurrentHashMap;", "setViews", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "createSVGMatrix", "Lcom/github/triniwiz/canvas/TNSDOMMatrix;", "nativeCustomWithBitmapFlush", "", "context", "view", "Landroid/graphics/Bitmap;", "nativeDataURL", "type", "quality", "", "nativeDestroyContext", "nativeFlush", "nativeInitContext", "width", "height", "density", "bufferId", "", "samples", "alpha", "fontColor", "ppi", "nativeInitContextWithCustomSurface", "nativeResizeCustomSurface", "nativeResizeSurface", "nativeSnapshotCanvas", "", "nativeToData", "canvas_release"})
    public static final class Companion {
        @NotNull
        public final ConcurrentHashMap<?, ?> getViews() {
            return views;
        }

        public final void setViews(@NotNull ConcurrentHashMap<?, ?> concurrentHashMap) {
            Intrinsics.checkNotNullParameter(concurrentHashMap, (String)"<set-?>");
            views = concurrentHashMap;
        }

        @JvmStatic
        public final long nativeInitContext(float f, float f2, float f3, int n, int n2, boolean bl, int n3, float f4, int n4) {
            return TNSCanvas.nativeInitContext(f, f2, f3, n, n2, bl, n3, f4, n4);
        }

        @JvmStatic
        public final long nativeInitContextWithCustomSurface(float f, float f2, float f3, boolean bl, int n, float f4, int n2) {
            return TNSCanvas.nativeInitContextWithCustomSurface(f, f2, f3, bl, n, f4, n2);
        }

        @JvmStatic
        public final void nativeResizeCustomSurface(long l, float f, float f2, float f3, boolean bl, int n) {
            TNSCanvas.nativeResizeCustomSurface(l, f, f2, f3, bl, n);
        }

        @JvmStatic
        public final void nativeResizeSurface(long l, float f, float f2, float f3, int n, int n2, boolean bl, float f4) {
            TNSCanvas.nativeResizeSurface(l, f, f2, f3, n, n2, bl, f4);
        }

        @JvmStatic
        private final void nativeDestroyContext(long l) {
            TNSCanvas.nativeDestroyContext(l);
        }

        @JvmStatic
        public final void nativeFlush(long l) {
            TNSCanvas.nativeFlush(l);
        }

        @JvmStatic
        public final void nativeCustomWithBitmapFlush(long l, @NotNull Bitmap bitmap) {
            TNSCanvas.nativeCustomWithBitmapFlush(l, bitmap);
        }

        @JvmStatic
        private final String nativeDataURL(long l, String string, float f) {
            return TNSCanvas.nativeDataURL(l, string, f);
        }

        @JvmStatic
        private final byte[] nativeToData(long l) {
            return TNSCanvas.nativeToData(l);
        }

        @JvmStatic
        private final byte[] nativeSnapshotCanvas(long l) {
            return TNSCanvas.nativeSnapshotCanvas(l);
        }

        public final long getLastCall$canvas_release() {
            return lastCall;
        }

        public final void setLastCall$canvas_release(long l) {
            lastCall = l;
        }

        public final boolean isLibraryLoaded$canvas_release() {
            return isLibraryLoaded;
        }

        public final void setLibraryLoaded$canvas_release(boolean bl) {
            isLibraryLoaded = bl;
        }

        @JvmStatic
        @NotNull
        public final TNSDOMMatrix createSVGMatrix() {
            return new TNSDOMMatrix();
        }

        @JvmStatic
        public static /* synthetic */ void getDirection$canvas_release$annotations() {
        }

        @NotNull
        public final TNSTextDirection getDirection$canvas_release() {
            TNSTextDirection direction2 = TNSTextDirection.Ltr;
            if (TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1) {
                direction2 = TNSTextDirection.Rtl;
            }
            return direction2;
        }

        private Companion() {
        }

        public static final /* synthetic */ byte[] access$nativeToData(Companion $this, long context) {
            return $this.nativeToData(context);
        }

        public static final /* synthetic */ byte[] access$nativeSnapshotCanvas(Companion $this, long context) {
            return $this.nativeSnapshotCanvas(context);
        }

        public static final /* synthetic */ String access$nativeDataURL(Companion $this, long context, String type, float quality) {
            return $this.nativeDataURL(context, type, quality);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

