/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import com.github.triniwiz.canvas.CanvasColorStyleType;
import com.github.triniwiz.canvas.ICanvasColorStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Gradient
implements ICanvasColorStyle {
    Map<Float, Integer> gradientMap = new HashMap<Float, Integer>();
    ArrayList<Integer> colors = new ArrayList();
    ArrayList<Float> keys = new ArrayList();

    Gradient() {
    }

    @Override
    public CanvasColorStyleType getStyleType() {
        return CanvasColorStyleType.Gradient;
    }

    public void addColorStop(float offset, int color) throws Exception {
        if (offset < 0.0f) {
            throw new Exception("INDEX_SIZE_ERR");
        }
        if (offset > 1.0f) {
            throw new Exception("INDEX_SIZE_ERR");
        }
        this.gradientMap.put(Float.valueOf(offset), color);
        this.colors.add(color);
        this.keys.add(Float.valueOf(offset));
    }

    int[] getColors() {
        Collection<Integer> valuesCollection = this.gradientMap.values();
        int[] rawValues = new int[valuesCollection.size()];
        int i = 0;
        for (Integer value : valuesCollection) {
            rawValues[i] = value;
            ++i;
        }
        return rawValues;
    }

    float[] getPositions() {
        Set<Float> keysSet = this.gradientMap.keySet();
        float[] rawKeys = new float[keysSet.size()];
        int i = 0;
        for (Float key : keysSet) {
            rawKeys[i] = key.floatValue();
            ++i;
        }
        return rawKeys;
    }
}

