/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.graphics.Bitmap;
import com.github.triniwiz.canvas.CanvasColorStyleType;
import com.github.triniwiz.canvas.CanvasDOMMatrix;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.ICanvasColorStyle;
import com.github.triniwiz.canvas.ImageAsset;
import java.util.concurrent.CountDownLatch;

public class Pattern
implements ICanvasColorStyle {
    long nativePattern;

    private static native long nativeCreatePattern(Bitmap var0, String var1);

    private static native long nativeCreatePatternRaw(byte[] var0, int var1, int var2, String var3);

    private static native long nativeCreatePatternCanvas(byte[] var0, String var1);

    private static native void nativeFree(long var0);

    private static native long nativeSetPatternTransform(long var0, long var2);

    public Pattern(CanvasView parent, CanvasView src, final PatternRepetition repetition) {
        final byte[] ss = src.snapshot();
        final CountDownLatch lock = new CountDownLatch(1);
        final long[] ptr = new long[1];
        parent.queueEvent(new Runnable(){

            @Override
            public void run() {
                ptr[0] = Pattern.nativeCreatePatternCanvas(ss, repetition.pattern);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nativePattern = ptr[0];
    }

    public Pattern(CanvasView parent, final Bitmap src, final PatternRepetition repetition) {
        final CountDownLatch lock = new CountDownLatch(1);
        final long[] ptr = new long[1];
        parent.queueEvent(new Runnable(){

            @Override
            public void run() {
                ptr[0] = Pattern.nativeCreatePattern(src, repetition.pattern);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nativePattern = ptr[0];
    }

    public Pattern(CanvasView parent, final ImageAsset src, final PatternRepetition repetition) {
        final CountDownLatch lock = new CountDownLatch(1);
        final long[] ptr = new long[1];
        parent.queueEvent(new Runnable(){

            @Override
            public void run() {
                ptr[0] = Pattern.nativeCreatePatternRaw(src.getBytes(), src.getWidth(), src.getHeight(), repetition.pattern);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nativePattern = ptr[0];
    }

    private void destroy() {
        if (this.nativePattern != 0L) {
            Pattern.nativeFree(this.nativePattern);
        }
    }

    public void setTransform(CanvasDOMMatrix matrix) {
        this.nativePattern = Pattern.nativeSetPatternTransform(this.nativePattern, matrix.matrix);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    @Override
    public CanvasColorStyleType getStyleType() {
        return CanvasColorStyleType.Pattern;
    }

    public static enum PatternRepetition {
        Repeat("repeat"),
        RepeatX("repeat-x"),
        RepeatY("repeat-y"),
        NoRepeat("no-repeat");

        private String pattern;

        private PatternRepetition(String pattern) {
            this.pattern = pattern;
        }

        public String toString() {
            return this.pattern;
        }
    }
}

