/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.graphics.Bitmap;
import androidx.annotation.Nullable;
import com.github.triniwiz.canvas.ImageAssetFormat;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImageAsset {
    private long nativeImageAsset = ImageAsset.nativeInit();
    private static ExecutorService executorService = Executors.newCachedThreadPool();

    private static native long nativeInit();

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native int nativeFlipX(long var0);

    private static native int nativeFlipY(long var0);

    private static native byte[] nativeGetBytes(long var0);

    private static native long nativeScale(long var0, int var2, int var3);

    private static native String nativeGetError(long var0);

    private static native boolean nativeHasError(long var0);

    private static native boolean nativeSave(long var0, String var2, int var3);

    private static native boolean nativeLoadAssetPath(long var0, String var2);

    private static native boolean nativeLoadAssetBuffer(long var0, byte[] var2);

    private static native void nativeRelease(long var0);

    public int getWidth() {
        if (this.nativeImageAsset == 0L) {
            return 0;
        }
        return ImageAsset.nativeGetWidth(this.nativeImageAsset);
    }

    public int getHeight() {
        if (this.nativeImageAsset == 0L) {
            return 0;
        }
        return ImageAsset.nativeGetHeight(this.nativeImageAsset);
    }

    public byte[] getBytes() {
        return ImageAsset.nativeGetBytes(this.nativeImageAsset);
    }

    @Nullable
    public String getError() {
        if (this.nativeImageAsset == 0L) {
            return null;
        }
        if (!ImageAsset.nativeHasError(this.nativeImageAsset)) {
            return null;
        }
        return ImageAsset.nativeGetError(this.nativeImageAsset);
    }

    public void scale(int x, int y) {
        if (this.nativeImageAsset == 0L) {
            return;
        }
        this.nativeImageAsset = ImageAsset.nativeScale(this.nativeImageAsset, x, y);
    }

    public void flipX() {
        if (this.nativeImageAsset == 0L) {
            return;
        }
        this.nativeImageAsset = ImageAsset.nativeFlipX(this.nativeImageAsset);
    }

    public void flipY() {
        if (this.nativeImageAsset == 0L) {
            return;
        }
        this.nativeImageAsset = ImageAsset.nativeFlipY(this.nativeImageAsset);
    }

    public boolean save(String path, ImageAssetFormat format) {
        if (this.nativeImageAsset == 0L) {
            return false;
        }
        return ImageAsset.nativeSave(this.nativeImageAsset, path, format.getFormat());
    }

    public void saveAsync(final String path, final ImageAssetFormat format, final Callback callback) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (ImageAsset.this.save(path, format)) {
                    callback.onSuccess(true);
                } else {
                    callback.onError(ImageAsset.this.getError());
                }
            }
        });
    }

    public boolean loadImageFromPath(String path) {
        if (this.nativeImageAsset == 0L) {
            return false;
        }
        return ImageAsset.nativeLoadAssetPath(this.nativeImageAsset, path);
    }

    public void loadImageFromPathAsync(final String path, final Callback callback) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (ImageAsset.nativeLoadAssetPath(ImageAsset.this.nativeImageAsset, path)) {
                    callback.onSuccess(true);
                } else {
                    callback.onError(ImageAsset.this.getError());
                }
            }
        });
    }

    public boolean loadImageFromBytes(byte[] buffer) {
        if (this.nativeImageAsset == 0L) {
            return false;
        }
        return ImageAsset.nativeLoadAssetBuffer(this.nativeImageAsset, buffer);
    }

    public void loadImageFromBytesAsync(final byte[] buffer, final Callback callback) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (ImageAsset.nativeLoadAssetBuffer(ImageAsset.this.nativeImageAsset, buffer)) {
                    callback.onSuccess(true);
                } else {
                    callback.onError(ImageAsset.this.getError());
                }
            }
        });
    }

    public boolean loadImageFromImage(Bitmap bitmap) {
        if (this.nativeImageAsset == 0L) {
            return false;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        return this.loadImageFromBytes(os.toByteArray());
    }

    public void loadImageFromImageAsync(final Bitmap bitmap, final Callback callback) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
                if (ImageAsset.this.loadImageFromBytes(os.toByteArray())) {
                    callback.onSuccess(true);
                } else {
                    callback.onError(ImageAsset.this.getError());
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        ImageAsset.nativeRelease(this.nativeImageAsset);
        this.nativeImageAsset = 0L;
        super.finalize();
    }

    public static interface Callback {
        public void onSuccess(Object var1);

        public void onError(String var1);
    }
}

