/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.GLContext;

public class GLView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private boolean isCreated = false;
    private boolean isCreatedWithZeroSized = false;
    private GLContext mGLContext;
    private CanvasView.Listener mListener;

    public GLView(Context context) {
        super(context);
        this.init();
    }

    public GLView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    void init() {
        this.setOpaque(false);
        this.mGLContext = new GLContext();
        this.setSurfaceTextureListener(this);
    }

    public void flush() {
        this.mGLContext.flush();
    }

    public GLContext getGLContext() {
        return this.mGLContext;
    }

    public void queueEvent(Runnable runnable) {
        this.mGLContext.queueEvent(runnable);
    }

    public void setListener(CanvasView.Listener listener) {
        this.mListener = listener;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (!this.isCreated) {
            if (width == 0 || height == 0) {
                this.isCreatedWithZeroSized = true;
            }
            if (!this.isCreatedWithZeroSized) {
                this.mGLContext.init(surface);
                if (this.mListener != null) {
                    this.mListener.contextReady();
                }
            }
            this.isCreated = true;
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (this.isCreatedWithZeroSized && (width != 0 || height != 0)) {
            this.mGLContext.init(surface);
            this.isCreatedWithZeroSized = false;
            if (this.mListener != null) {
                this.mListener.contextReady();
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.isCreated = false;
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

