/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas.extensions;

import android.opengl.GLES30;
import androidx.annotation.RequiresApi;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.Constants;
import java.util.concurrent.CountDownLatch;

@RequiresApi(api=18)
public class EXT_disjoint_timer_query {
    public static int QUERY_COUNTER_BITS_EXT = Constants.GL_QUERY_COUNTER_BITS_EXT;
    public static int CURRENT_QUERY_EXT = Constants.GL_CURRENT_QUERY_EXT;
    public static int QUERY_RESULT_EXT = Constants.GL_QUERY_RESULT_EXT;
    public static int QUERY_RESULT_AVAILABLE_EXT = Constants.GL_QUERY_RESULT_AVAILABLE_EXT;
    public static int TIME_ELAPSED_EXT = Constants.GL_TIME_ELAPSED_EXT;
    public static int TIMESTAMP_EXT = Constants.GL_TIMESTAMP_EXT;
    public static int GPU_DISJOINT_EXT = Constants.GL_GPU_DISJOINT_EXT;
    CanvasView canvas;

    public EXT_disjoint_timer_query(CanvasView canvas) {
        this.canvas = canvas;
    }

    public int createQueryEXT() {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] query = new int[1];
        this.canvas.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES30.glGenQueries((int)1, (int[])query, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return query[0];
    }

    public void deleteQueryEXT(int query) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] id = new int[]{query};
        this.canvas.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES30.glDeleteQueries((int)1, (int[])id, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isQueryEXT(final int query) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.canvas.queueEvent(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glIsQuery((int)query);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public void beginQueryEXT(final int target, final int query) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.canvas.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES30.glBeginQuery((int)target, (int)query);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void endQueryEXT(final int target) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.canvas.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES30.glEndQuery((int)target);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void queryCounterEXT(int query, int target) {
    }

    public int getQueryEXT(final int target, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] query = new int[1];
        this.canvas.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES30.glGetQueryiv((int)target, (int)pname, (int[])query, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return query[0];
    }

    public Object getQueryObjectEXT(final int query, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] value = new int[1];
        this.canvas.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES30.glGetQueryObjectuiv((int)query, (int)pname, (int[])value, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (pname == QUERY_RESULT_AVAILABLE_EXT) {
            return value[0] == 1;
        }
        return value[0];
    }
}

