/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.os.Handler;
import android.os.HandlerThread;
import android.view.Choreographer;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AnimationFrame
implements Choreographer.FrameCallback {
    private static ConcurrentHashMap<String, Callback> callbacks;
    static long lastCall;
    static int count;
    static Timer timer;
    static AnimationFrame instance;
    static HandlerThread handlerThread;
    static Handler handler;
    static final Object lock;
    static Choreographer choreographer;

    public void doFrame(long frameTimeNanos) {
        final long dt = TimeUnit.NANOSECONDS.toMillis(frameTimeNanos - lastCall);
        handler.post(new Runnable(){

            @Override
            public void run() {
                Set set = callbacks.entrySet();
                for (Map.Entry callback : set) {
                    ((Callback)callback.getValue()).onFrame(dt);
                    if (((String)callback.getKey()).equals("main")) continue;
                    callbacks.remove(callback.getKey());
                }
            }
        });
        lastCall = frameTimeNanos;
        Choreographer.getInstance().postFrameCallbackDelayed((Choreographer.FrameCallback)instance, TimeUnit.MILLISECONDS.toNanos(dt));
    }

    public static String requestAnimationFrame(Callback callback) {
        String id = UUID.randomUUID().toString();
        callbacks.put(id, callback);
        if (choreographer == null) {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)instance);
        }
        return id;
    }

    static void requestAnimationFrame(String id, Callback callback) {
        callbacks.put(id, callback);
    }

    public static void cancelAnimationFrame(String id) {
        callbacks.remove(id);
        if (callbacks.isEmpty()) {
            Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)instance);
            choreographer = null;
        }
    }

    static {
        lastCall = 0L;
        count = 0;
        lock = new Object();
        callbacks = new ConcurrentHashMap();
        instance = new AnimationFrame();
        handlerThread = new HandlerThread("AnimationFrame");
        handlerThread.start();
        handler = new Handler(handlerThread.getLooper());
    }

    public static interface Callback {
        public void onFrame(long var1);
    }
}

