/*
 * Decompiled with CFR 0.152.
 */
package com.trickl.flux.publishers;

import java.time.Duration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class FixedRatePublisher
implements Supplier<Flux<Long>> {
    private final Duration delay;
    private final Duration period;
    private final Scheduler scheduler;

    public FixedRatePublisher(Duration period) {
        this(Duration.ZERO, period, Schedulers.parallel());
    }

    @Override
    public Flux<Long> get() {
        DirectProcessor processor = DirectProcessor.create();
        FluxSink sink = processor.sink();
        return processor.doOnSubscribe(sub -> this.onSubscribe((FluxSink<Long>)sink)).doOnCancel(() -> this.onCancel((FluxSink<Long>)sink));
    }

    private void onSubscribe(FluxSink<Long> sink) {
        try {
            AtomicLong count = new AtomicLong();
            Disposable emitterTask = this.scheduler.schedulePeriodically(() -> sink.next((Object)count.getAndIncrement()), this.delay.toMillis(), this.period.toMillis(), TimeUnit.MILLISECONDS);
            sink.onCancel(() -> ((Disposable)emitterTask).dispose());
        }
        catch (RejectedExecutionException ree) {
            sink.error((Throwable)ree);
        }
    }

    private void onCancel(FluxSink<Long> sink) {
        sink.complete();
    }

    public FixedRatePublisher(Duration delay, Duration period, Scheduler scheduler) {
        this.delay = delay;
        this.period = period;
        this.scheduler = scheduler;
    }
}

