/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static Optional<File> findFolder(String folderName) {
        File rootFolder = new File(folderName);
        if (rootFolder.isDirectory()) {
            return Optional.of(rootFolder);
        }
        try {
            return Files.walk(new File(System.getProperty("user.dir")).toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isDirectory).filter(f -> Objects.equals(f.getName(), folderName)).findFirst();
        }
        catch (IOException ex) {
            LOGGER.warn("Exception while walking file tree.", (Throwable)ex);
            return Optional.empty();
        }
    }

    public static Collection<URL> filesToUrls(File ... jars) {
        if (jars == null) {
            return Collections.emptySet();
        }
        return Stream.of(jars).map(f -> {
            try {
                return Optional.of(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Skipping file: '{}'.", f, (Object)e);
                return Optional.empty();
            }
        }).flatMap(o -> o.map(u -> Stream.of((URL)u)).orElse(Stream.empty())).collect(Collectors.toSet());
    }
}

