/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.remote;

import com.github.triceo.robozonky.api.remote.ZonkyApi;
import com.github.triceo.robozonky.api.remote.ZonkyOAuthApi;
import com.github.triceo.robozonky.api.remote.entities.ZonkyApiToken;
import com.github.triceo.robozonky.common.remote.AuthenticatedFilter;
import com.github.triceo.robozonky.common.remote.AuthenticationFilter;
import com.github.triceo.robozonky.common.remote.RoboZonkyFilter;
import com.github.triceo.robozonky.internal.api.Settings;
import java.lang.ref.WeakReference;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.cache.BrowserCacheFeature;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiProvider
implements AutoCloseable {
    private static final ResteasyProviderFactory RESTEASY = ResteasyProviderFactory.getInstance();
    private static final HttpClientConnectionManager CONNECTION_MANAGER;
    private static final String ZONKY_URL = "https://api.zonky.cz";
    private final Collection<WeakReference<AutoCloseable>> clients = new ArrayList<WeakReference<AutoCloseable>>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    private static ResteasyClient newResteasyClient() {
        int socketTimeout = (int)Settings.INSTANCE.getSocketTimeout().get(ChronoUnit.SECONDS) * 1000;
        int connectionTimeout = (int)Settings.INSTANCE.getConnectionTimeout().get(ChronoUnit.SECONDS) * 1000;
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionTimeout).setSocketTimeout(socketTimeout).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager(CONNECTION_MANAGER).build();
        RedirectingHttpClient httpEngine = new RedirectingHttpClient((HttpClient)httpClient);
        return new ResteasyClientBuilder().httpEngine((ClientHttpEngine)httpEngine).providerFactory(RESTEASY).build();
    }

    protected <T> ApiWrapper<T> obtain(Class<T> api, String url, RoboZonkyFilter filter) {
        if (this.isClosed.get()) {
            throw new IllegalStateException("Attempting to use an already destroyed ApiProvider.");
        }
        ResteasyClient client = ApiProvider.newResteasyClient();
        Object proxy = client.register((Object)filter).target(url).register((Object)new BrowserCacheFeature()).proxy(api);
        ApiWrapper<Object> wrapper = new ApiWrapper<Object>(api, proxy, client);
        this.clients.add(new WeakReference<ApiWrapper<Object>>(wrapper));
        return wrapper;
    }

    public ApiWrapper<ZonkyOAuthApi> oauth() {
        return this.obtain(ZonkyOAuthApi.class, ZONKY_URL, new AuthenticationFilter());
    }

    public ApiWrapper<ZonkyApi> anonymous() {
        return this.obtain(ZonkyApi.class, ZONKY_URL, new RoboZonkyFilter());
    }

    public ApiWrapper<ZonkyApi> authenticated(ZonkyApiToken token) {
        return this.obtain(ZonkyApi.class, ZONKY_URL, new AuthenticatedFilter(token));
    }

    @Override
    public synchronized void close() {
        if (this.isClosed.get()) {
            return;
        }
        this.clients.stream().flatMap(w -> w.get() == null ? Stream.empty() : Stream.of(w.get())).forEach(c -> {
            try {
                c.close();
            }
            catch (Exception ex) {
                this.LOGGER.trace("Failed closing client: {}.", c, (Object)ex);
            }
        });
        this.isClosed.set(true);
        CONNECTION_MANAGER.closeExpiredConnections();
        CONNECTION_MANAGER.closeIdleConnections(5L, TimeUnit.MINUTES);
    }

    static {
        RegisterBuiltin.register((ResteasyProviderFactory)RESTEASY);
        Class<ResteasyJackson2Provider> jsonProvider = ResteasyJackson2Provider.class;
        if (!RESTEASY.isRegistered(jsonProvider)) {
            RESTEASY.registerProvider(jsonProvider);
        }
        CONNECTION_MANAGER = new PoolingHttpClientConnectionManager();
    }

    public static class ApiWrapper<T>
    implements AutoCloseable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ApiWrapper.class);
        private final ResteasyClient client;
        private final T api;

        public ApiWrapper(Class<T> apiClass, T api) {
            this(apiClass, api, null);
        }

        public ApiWrapper(Class<T> apiClass, T api, ResteasyClient client) {
            this.client = client;
            this.api = api;
        }

        public <S> S execute(Function<T, S> function) {
            return function.apply(this.api);
        }

        public void execute(Consumer<T> function) {
            function.accept(this.api);
        }

        boolean isClosed() {
            return this.client == null || this.client.isClosed();
        }

        @Override
        public synchronized void close() {
            if (this.client != null && !this.client.isClosed()) {
                this.client.close();
            }
        }
    }

    static class RedirectingHttpClient
    extends ApacheHttpClient43Engine {
        public RedirectingHttpClient(HttpClient httpClient) {
            super(httpClient);
        }

        protected void loadHttpMethod(ClientInvocation request, HttpRequestBase httpMethod) throws Exception {
            super.loadHttpMethod(request, httpMethod);
            httpMethod.setConfig(RequestConfig.copy((RequestConfig)httpMethod.getConfig()).setRedirectsEnabled(true).build());
        }
    }
}

