/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.strategies.InvestmentStrategy;
import com.github.triceo.robozonky.api.strategies.InvestmentStrategyService;
import com.github.triceo.robozonky.common.extensions.ExtensionsManager;
import com.github.triceo.robozonky.internal.api.Defaults;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvestmentStrategyLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvestmentStrategyLoader.class);
    private static final ServiceLoader<InvestmentStrategyService> STRATEGY_LOADER = ExtensionsManager.INSTANCE.getServiceLoader(InvestmentStrategyService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<InvestmentStrategy> processInvestmentStrategyService(InvestmentStrategyService service, String strategy) {
        LOGGER.debug("Reading strategy.");
        try (ByteArrayInputStream stream = new ByteArrayInputStream(strategy.getBytes(Defaults.CHARSET));){
            Optional optional = service.parse((InputStream)stream);
            return optional;
        }
        catch (Exception ex) {
            LOGGER.error("Failed reading strategy.", (Throwable)ex);
            return Optional.empty();
        }
    }

    public static Optional<InvestmentStrategy> load(String strategy) {
        return StreamSupport.stream(STRATEGY_LOADER.spliterator(), true).map(iss -> InvestmentStrategyLoader.processInvestmentStrategyService(iss, strategy)).flatMap(o -> o.map(Stream::of).orElse(Stream.empty())).findFirst();
    }
}

