/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.util;

import com.github.triceo.robozonky.api.Refreshable;
import com.github.triceo.robozonky.util.Scheduler;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.Test;

public class SchedulerTest {
    private static final Refreshable<String> REFRESHABLE = new Refreshable<String>(){
        private final Refreshable<Void> immutable = Refreshable.createImmutable();

        public Optional<Refreshable<?>> getDependedOn() {
            return Optional.of(this.immutable);
        }

        protected Supplier<Optional<String>> getLatestSource() {
            return () -> Optional.of("");
        }

        protected Optional<String> transform(String source) {
            return Optional.of(source);
        }
    };

    @Test
    public void lifecycle() {
        Scheduler s = new Scheduler();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(s.isShutdown()).isFalse();
            softly.assertThat(s.isSubmitted(REFRESHABLE)).isFalse();
        });
        s.submit(REFRESHABLE);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(s.isSubmitted(REFRESHABLE)).isTrue();
            softly.assertThat(s.isSubmitted((Runnable)REFRESHABLE.getDependedOn().get())).isTrue();
        });
        s.shutdown();
        Assertions.assertThat((boolean)s.isShutdown()).isTrue();
    }

    @Test
    public void reinitBeforeShutdown() {
        Refreshable r = Refreshable.createImmutable();
        Scheduler s = new Scheduler();
        s.submit((Runnable)r);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(s.isSubmitted((Runnable)r)).isTrue();
            softly.assertThat(s.isShutdown()).isFalse();
            softly.assertThat(s.reinit()).isFalse();
        });
        s.shutdown();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(s.isShutdown()).isTrue();
            softly.assertThat(s.reinit()).isTrue();
        });
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(s.isSubmitted((Runnable)r)).isFalse();
            softly.assertThat(s.isShutdown()).isFalse();
        });
    }
}

