/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.secrets;

import com.github.triceo.robozonky.common.secrets.KeyStoreHandler;
import com.github.triceo.robozonky.common.secrets.SecretProvider;
import com.github.triceo.robozonky.util.IOUtils;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KeyStoreSecretProvider
implements SecretProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreSecretProvider.class);
    private static final String ALIAS_PASSWORD = "pwd";
    private static final String ALIAS_USERNAME = "usr";
    private static final String ALIAS_TOKEN = "tkn";
    private static final String ALIAS_TOKEN_DATE = "tknd";
    private final KeyStoreHandler ksh;

    private static String getSecretIdentifier(String secretId) {
        return "sct-" + secretId;
    }

    public KeyStoreSecretProvider(KeyStoreHandler ksh) {
        if (ksh == null) {
            throw new IllegalArgumentException("KeyStoreHandler must be provided.");
        }
        this.ksh = ksh;
    }

    private boolean set(String alias, Reader valueStream) {
        return this.set(alias, IOUtils.toString(valueStream));
    }

    private boolean set(String alias, String value) {
        return this.set(alias, value.toCharArray());
    }

    private boolean set(String alias, char[] value) {
        try {
            boolean result = this.ksh.set(alias, value);
            this.ksh.save();
            return result;
        }
        catch (IOException ex) {
            LOGGER.warn("Failed saving keystore.", (Throwable)ex);
            return false;
        }
    }

    @Override
    public char[] getPassword() {
        return this.ksh.get(ALIAS_PASSWORD).orElseThrow(() -> new IllegalStateException("Password not present in KeyStore."));
    }

    @Override
    public String getUsername() {
        return new String(this.ksh.get(ALIAS_USERNAME).orElseThrow(() -> new IllegalStateException("Username not present in KeyStore.")));
    }

    public boolean setPassword(char[] password) {
        return this.set(ALIAS_PASSWORD, password);
    }

    public boolean setUsername(String username) {
        return this.set(ALIAS_USERNAME, username);
    }

    @Override
    public Optional<Reader> getToken() {
        Optional<char[]> stored = this.ksh.get(ALIAS_TOKEN);
        if (stored.isPresent()) {
            return Optional.of(new CharArrayReader(stored.get()));
        }
        return Optional.empty();
    }

    @Override
    public boolean setToken(Reader token) {
        boolean firstSuccessful = this.set(ALIAS_TOKEN, token);
        boolean secondSuccessful = this.set(ALIAS_TOKEN_DATE, OffsetDateTime.now().toString());
        return firstSuccessful && secondSuccessful;
    }

    @Override
    public Optional<char[]> getSecret(String secretId) {
        return this.ksh.get(KeyStoreSecretProvider.getSecretIdentifier(secretId));
    }

    @Override
    public boolean setSecret(String secretId, char ... secret) {
        return this.set(KeyStoreSecretProvider.getSecretIdentifier(secretId), secret);
    }

    @Override
    public boolean deleteToken() {
        boolean result = this.ksh.delete(ALIAS_TOKEN);
        result = this.ksh.delete(ALIAS_TOKEN_DATE) && result;
        try {
            this.ksh.save();
            return result;
        }
        catch (IOException ex) {
            LOGGER.warn("Failed saving keystore.", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }
}

