/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.secrets;

import com.github.triceo.robozonky.common.secrets.SecretProvider;
import com.github.triceo.robozonky.internal.api.State;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FallbackSecretProvider
implements SecretProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackSecretProvider.class);
    private static final State.ClassSpecificState STATE = State.INSTANCE.forClass(FallbackSecretProvider.class);
    private static final String TOKEN_STATE_ID = "token";
    private final String username;
    private final char[] password;
    private final Map<String, char[]> secrets = new HashMap<String, char[]>();

    public FallbackSecretProvider(String username, char ... password) {
        this.username = username;
        this.password = Arrays.copyOf(password, password.length);
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public Optional<Reader> getToken() {
        return STATE.getValue(TOKEN_STATE_ID).map(o -> Optional.of(new StringReader((String)o))).orElse(Optional.empty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setToken(Reader token) {
        try (BufferedReader r = new BufferedReader(token);){
            STATE.setValue(TOKEN_STATE_ID, r.readLine());
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            LOGGER.warn("Failed setting token.", (Throwable)ex);
            return false;
        }
    }

    @Override
    public Optional<char[]> getSecret(String secretId) {
        return Optional.ofNullable(this.secrets.get(secretId));
    }

    @Override
    public boolean setSecret(String secretId, char ... secret) {
        this.secrets.put(secretId, secret);
        return true;
    }

    @Override
    public boolean deleteToken() {
        return STATE.reset();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }
}

