/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.secrets;

import com.github.triceo.robozonky.common.secrets.SecretProvider;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Credentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(Credentials.class);
    private final String toolId;
    private final SecretProvider secretProvider;

    public Credentials(String request, SecretProvider secretProvider) {
        this.secretProvider = secretProvider;
        Object[] parts = request.split(":");
        if (parts.length == 1) {
            this.toolId = parts[0];
            LOGGER.debug("Credentials for '{}' not given password.", (Object)this.toolId);
        } else if (parts.length == 2) {
            this.toolId = parts[0];
            this.secretProvider.setSecret(this.toolId, ((String)parts[1]).toCharArray());
            LOGGER.debug("Credentials for '{}' stored password.", (Object)this.toolId);
        } else {
            throw new IllegalArgumentException("Request must be 1 or 2 parts: " + Arrays.toString(parts));
        }
    }

    public String getToolId() {
        return this.toolId;
    }

    public Optional<char[]> getToken() {
        return this.secretProvider.getSecret(this.toolId);
    }

    public String toString() {
        return "Credentials{toolId='" + this.toolId + '\'' + '}';
    }
}

