/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.Refreshable;
import com.github.triceo.robozonky.api.notifications.Event;
import com.github.triceo.robozonky.api.notifications.EventListener;
import com.github.triceo.robozonky.api.notifications.ListenerService;
import com.github.triceo.robozonky.common.extensions.ExtensionsManager;
import com.github.triceo.robozonky.util.Scheduler;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListenerServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerServiceLoader.class);
    private static final ServiceLoader<ListenerService> LOADER = ExtensionsManager.INSTANCE.getServiceLoader(ListenerService.class);

    private static <T> Stream<T> iteratorToStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static <T extends Event> List<Refreshable<EventListener<T>>> load(Class<T> eventType, Iterable<ListenerService> loader, Scheduler scheduler) {
        return ((Stream)ListenerServiceLoader.iteratorToStream(loader).parallel()).peek(s -> LOGGER.debug("Processing '{}'.", s.getClass())).map(s -> s.findListener(eventType)).peek(scheduler::submit).collect(Collectors.toList());
    }

    public static <T extends Event> List<Refreshable<EventListener<T>>> load(Class<T> eventType) {
        return ListenerServiceLoader.load(eventType, LOADER, Scheduler.BACKGROUND_SCHEDULER);
    }
}

