/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.util.FileUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum ExtensionsManager {
    INSTANCE;

    private final Logger LOGGER = LoggerFactory.getLogger(ExtensionsManager.class);

    ClassLoader retrieveExtensionClassLoader(File extensionsFolder) {
        this.LOGGER.debug("Using extensions folder: '{}'.", (Object)extensionsFolder.getAbsolutePath());
        Collection<URL> urls = FileUtils.filesToUrls(extensionsFolder.listFiles(f -> f.getPath().toLowerCase().endsWith(".jar")));
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    ClassLoader retrieveExtensionClassLoader(String folderName) {
        return FileUtils.findFolder(folderName).map(this::retrieveExtensionClassLoader).orElseGet(() -> {
            this.LOGGER.debug("Extensions folder not found.");
            return ExtensionsManager.class.getClassLoader();
        });
    }

    public <T> ServiceLoader<T> getServiceLoader(Class<T> serviceClass) {
        return this.getServiceLoader(serviceClass, "extensions");
    }

    <T> ServiceLoader<T> getServiceLoader(Class<T> serviceClass, String folderName) {
        this.LOGGER.debug("Retrieving service loader for '{}'.", serviceClass);
        return ServiceLoader.load(serviceClass, this.retrieveExtensionClassLoader(folderName));
    }
}

