/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.confirmations.ConfirmationProvider;
import com.github.triceo.robozonky.api.confirmations.ConfirmationProviderService;
import com.github.triceo.robozonky.common.extensions.ExtensionsManager;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfirmationProviderLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfirmationProviderLoader.class);
    private static final ServiceLoader<ConfirmationProviderService> LOADER = ExtensionsManager.INSTANCE.getServiceLoader(ConfirmationProviderService.class);

    public static Optional<ConfirmationProvider> load(String providerId) {
        LOGGER.trace("Looking up confirmation provider '{}'.", (Object)providerId);
        return StreamSupport.stream(LOADER.spliterator(), false).peek(cp -> LOGGER.debug("Evaluating confirmation provider '{}' with '{}'.", (Object)providerId, cp.getClass())).map(cp -> cp.find(providerId)).flatMap(o -> o.map(Stream::of).orElse(Stream.empty())).findFirst();
    }
}

