/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.Refreshable;
import com.github.triceo.robozonky.api.confirmations.ConfirmationProvider;
import com.github.triceo.robozonky.api.confirmations.RequestId;
import com.github.triceo.robozonky.api.notifications.Event;
import com.github.triceo.robozonky.api.notifications.EventListener;
import com.github.triceo.robozonky.api.notifications.RoboZonkyTestingEvent;
import com.github.triceo.robozonky.api.remote.ZonkyApi;
import com.github.triceo.robozonky.api.remote.entities.Loan;
import com.github.triceo.robozonky.common.extensions.ListenerServiceLoader;
import com.github.triceo.robozonky.common.remote.ApiProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checker {
    private static final Logger LOGGER = LoggerFactory.getLogger(Checker.class);
    private static final Comparator<Loan> SUBCOMPARATOR = Comparator.comparing(Loan::getRemainingInvestment).reversed();
    private static final Comparator<Loan> COMPARATOR = Comparator.comparing(Loan::getInterestRate).thenComparing(SUBCOMPARATOR);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<Loan> getOneLoanFromMarketplace(Supplier<ApiProvider> apiProviderSupplier) {
        try (ApiProvider p = apiProviderSupplier.get();){
            ApiProvider.ApiWrapper<ZonkyApi> oauth = p.anonymous();
            Collection loans = oauth.execute(ZonkyApi::getLoans);
            Optional<Loan> optional = loans.stream().sorted(COMPARATOR).findFirst();
            return optional;
        }
        catch (Throwable t) {
            LOGGER.warn("Failed obtaining a loan.", t);
            return Optional.empty();
        }
    }

    static Optional<Boolean> notifyProvider(Loan loan, ConfirmationProvider zonkoid, String username, char[] secret) {
        RequestId id = new RequestId(username, secret);
        return zonkoid.requestConfirmation(id, loan.getId(), 200).map(c -> {
            switch (c.getType()) {
                case APPROVED: 
                case DELEGATED: {
                    return Optional.of(true);
                }
            }
            return Optional.of(false);
        }).orElse(Optional.empty());
    }

    public static Optional<Boolean> confirmations(ConfirmationProvider provider, String username, char[] secret) {
        return Checker.confirmations(provider, username, secret, ApiProvider::new);
    }

    static Optional<Boolean> confirmations(ConfirmationProvider provider, String username, char[] secret, Supplier<ApiProvider> apiProviderSupplier) {
        return Checker.getOneLoanFromMarketplace(apiProviderSupplier).map(l -> Checker.notifyProvider(l, provider, username, secret)).orElse(Optional.of(false));
    }

    public static boolean notifications() {
        return Checker.notifications(ListenerServiceLoader.load(RoboZonkyTestingEvent.class));
    }

    public static boolean notifications(List<Refreshable<EventListener<RoboZonkyTestingEvent>>> refreshables) {
        Collection listeners = refreshables.stream().flatMap(r -> r.getLatest().map(Stream::of).orElse(Stream.empty())).collect(Collectors.toSet());
        if (listeners.size() > 0) {
            RoboZonkyTestingEvent evt = new RoboZonkyTestingEvent();
            listeners.forEach(l -> l.handle((Event)evt));
            return true;
        }
        return false;
    }
}

