/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.secrets;

import com.github.triceo.robozonky.common.AbstractStateLeveragingTest;
import com.github.triceo.robozonky.common.secrets.FallbackSecretProvider;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.Test;

public class FallbackSecretProviderTest
extends AbstractStateLeveragingTest {
    private static final String USR = "username";
    private static final String PWD = "password";

    @Test
    public void setUsernameAndPassword() {
        FallbackSecretProvider p = new FallbackSecretProvider(USR, PWD.toCharArray());
        Assertions.assertThat((String)p.getUsername()).isEqualTo((Object)USR);
        Assertions.assertThat((char[])p.getPassword()).isEqualTo((Object)PWD.toCharArray());
        String key = "key";
        String value = "value";
        Assertions.assertThat((Optional)p.getSecret("key")).isEmpty();
        Assertions.assertThat((boolean)p.setSecret("key", "value".toCharArray())).isTrue();
        Assertions.assertThat((Optional)p.getSecret("key")).contains((Object)"value".toCharArray());
        Assertions.assertThat((boolean)p.isPersistent()).isFalse();
    }

    @Test
    public void tokenManipulation() {
        FallbackSecretProvider p = new FallbackSecretProvider(USR, PWD.toCharArray());
        String token = UUID.randomUUID().toString();
        SoftAssertions softly = new SoftAssertions();
        softly.assertThat(p.setToken((Reader)new StringReader(token))).isTrue();
        softly.assertThat(p.getToken()).isPresent();
        softly.assertAll();
        softly = new SoftAssertions();
        softly.assertThat(p.deleteToken()).isTrue();
        softly.assertAll();
    }
}

