/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.remote;

import com.github.triceo.robozonky.api.remote.ZonkyApi;
import com.github.triceo.robozonky.api.remote.entities.ZonkyApiToken;
import com.github.triceo.robozonky.common.remote.ApiProvider;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class ApiProviderTest {
    @Test
    public void authenticated() {
        ApiProvider.ApiWrapper api;
        try (ApiProvider provider = new ApiProvider();){
            api = provider.authenticated((ZonkyApiToken)Mockito.mock(ZonkyApiToken.class));
            Assertions.assertThat((Object)api).isNotNull();
        }
        Assertions.assertThatThrownBy(() -> {
            List cfr_ignored_0 = (List)api.execute(ZonkyApi::getLoans);
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void standard() {
        try (ApiProvider provider = new ApiProvider();){
            Assertions.assertThat((Object)provider.anonymous()).isNotNull();
        }
    }

    @Test
    public void oauth() {
        try (ApiProvider provider = new ApiProvider();){
            Assertions.assertThat((Object)provider.oauth()).isNotNull();
        }
    }

    @Test
    public void obtainClosedThrows() {
        try (ApiProvider provider = new ApiProvider();){
            try (ApiProvider.ApiWrapper w = provider.anonymous();){
                Assertions.assertThat((boolean)w.isClosed()).isFalse();
                provider.close();
                Assertions.assertThat((boolean)w.isClosed()).isTrue();
            }
            Assertions.assertThatThrownBy(() -> ((ApiProvider)provider).anonymous()).isInstanceOf(IllegalStateException.class);
        }
    }
}

