/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.Refreshable;
import com.github.triceo.robozonky.api.notifications.EventListener;
import com.github.triceo.robozonky.api.notifications.ListenerService;
import com.github.triceo.robozonky.api.notifications.RoboZonkyStartingEvent;
import com.github.triceo.robozonky.common.extensions.ListenerServiceLoader;
import com.github.triceo.robozonky.util.Scheduler;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ListenerServiceLoaderTest {
    @Test
    public void correctLoading() {
        RoboZonkyStartingEvent e = new RoboZonkyStartingEvent("");
        EventListener l = (EventListener)Mockito.mock(EventListener.class);
        ListenerService s1 = (ListenerService)Mockito.mock(ListenerService.class);
        Refreshable returned = Refreshable.createImmutable((Object)l);
        returned.run();
        ((ListenerService)Mockito.doReturn((Object)returned).when((Object)s1)).findListener((Class)ArgumentMatchers.eq(e.getClass()));
        ListenerService s2 = (ListenerService)Mockito.mock(ListenerService.class);
        ((ListenerService)Mockito.doReturn((Object)Refreshable.createImmutable()).when((Object)s2)).findListener((Class)ArgumentMatchers.eq(e.getClass()));
        Iterable s = () -> Arrays.asList(s1, s2).iterator();
        List r = ListenerServiceLoader.load(RoboZonkyStartingEvent.class, s, (Scheduler)new Scheduler());
        Assertions.assertThat((List)r).hasSize(2);
        ((ObjectAssert)Assertions.assertThat((List)r).first()).has(new Condition(result -> result.getLatest().isPresent() && result.getLatest().get() == l, "Exists", new Object[0]));
        ((ObjectAssert)Assertions.assertThat((List)r).last()).has(new Condition(result -> !result.getLatest().isPresent(), "Does not exist", new Object[0]));
    }
}

