/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.util;

import com.github.triceo.robozonky.api.Refreshable;
import com.github.triceo.robozonky.internal.api.Settings;
import com.github.triceo.robozonky.util.RoboZonkyThreadFactory;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    private static final ThreadFactory THREAD_FACTORY = new RoboZonkyThreadFactory(new ThreadGroup("rzBackground"));
    private static final TemporalAmount REFRESH = Duration.ofMinutes(Settings.INSTANCE.getRemoteResourceRefreshIntervalInMinutes());
    public static final Scheduler BACKGROUND_SCHEDULER = new Scheduler(1);
    private final Supplier<ScheduledExecutorService> executorProvider;
    private ScheduledExecutorService executor;
    private final Set<Runnable> submitted = new LinkedHashSet<Runnable>();

    public Scheduler() {
        this(1);
    }

    public Scheduler(int poolSize) {
        this.executorProvider = () -> Executors.newScheduledThreadPool(poolSize, THREAD_FACTORY);
        this.executor = this.executorProvider.get();
    }

    private void actuallySubmit(Runnable toSchedule, TemporalAmount delayInBetween) {
        long delayInSeconds = delayInBetween.get(ChronoUnit.SECONDS);
        LOGGER.debug("Scheduling {} every {} seconds.", (Object)toSchedule, (Object)delayInSeconds);
        this.submitted.add(toSchedule);
        this.executor.scheduleWithFixedDelay(toSchedule, 0L, delayInSeconds, TimeUnit.SECONDS);
    }

    public void submit(Runnable toSchedule) {
        this.submit(toSchedule, REFRESH);
    }

    public void submit(Runnable toSchedule, TemporalAmount delayInBetween) {
        if (toSchedule instanceof Refreshable) {
            Optional maybeDependedOn = ((Refreshable)toSchedule).getDependedOn();
            maybeDependedOn.ifPresent(dependedOn -> this.submit((Runnable)dependedOn, delayInBetween));
        }
        if (!this.isSubmitted(toSchedule)) {
            this.actuallySubmit(toSchedule, delayInBetween);
        }
    }

    public boolean isSubmitted(Runnable refreshable) {
        return this.submitted.contains(refreshable);
    }

    public void shutdown() {
        LOGGER.debug("Shutting down.");
        this.executor.shutdownNow();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean reinit() {
        if (!this.isShutdown()) {
            LOGGER.debug("Not reinitializing scheduler as it is not yet shut down.");
            return false;
        }
        this.submitted.clear();
        this.executor = this.executorProvider.get();
        return true;
    }
}

