/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.secrets;

import com.github.triceo.robozonky.common.secrets.FallbackSecretProvider;
import com.github.triceo.robozonky.common.secrets.KeyStoreHandler;
import com.github.triceo.robozonky.common.secrets.KeyStoreSecretProvider;
import java.io.Reader;
import java.util.Optional;

public interface SecretProvider {
    public static SecretProvider keyStoreBased(KeyStoreHandler ksh) {
        return new KeyStoreSecretProvider(ksh);
    }

    public static SecretProvider keyStoreBased(KeyStoreHandler ksh, String user, char ... password) {
        KeyStoreSecretProvider ks = (KeyStoreSecretProvider)SecretProvider.keyStoreBased(ksh);
        ks.setPassword(password);
        ks.setUsername(user);
        return ks;
    }

    public static SecretProvider fallback(String username, char ... password) {
        return new FallbackSecretProvider(username, password);
    }

    public char[] getPassword();

    public String getUsername();

    public Optional<Reader> getToken();

    public boolean setToken(Reader var1);

    public Optional<char[]> getSecret(String var1);

    public boolean setSecret(String var1, char ... var2);

    public boolean deleteToken();

    public boolean isPersistent();
}

