/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.marketplaces.Marketplace;
import com.github.triceo.robozonky.api.marketplaces.MarketplaceService;
import com.github.triceo.robozonky.common.extensions.ExtensionsManager;
import com.github.triceo.robozonky.common.secrets.Credentials;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarketplaceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarketplaceLoader.class);
    private static final ServiceLoader<MarketplaceService> LOADER = ExtensionsManager.INSTANCE.getServiceLoader(MarketplaceService.class);

    static Optional<Marketplace> processMarketplace(MarketplaceService service, Credentials credentials) {
        String providerId = credentials.getToolId();
        LOGGER.debug("Evaluating marketplace '{}' with '{}'.", (Object)providerId, service.getClass());
        char[] secret = credentials.getToken().orElse(new char[0]);
        return service.find(providerId, secret);
    }

    public static Optional<Marketplace> load(Credentials credentials) {
        LOGGER.trace("Looking up marketplace '{}'.", (Object)credentials.getToolId());
        return StreamSupport.stream(LOADER.spliterator(), false).map(service -> MarketplaceLoader.processMarketplace(service, credentials)).flatMap(o -> o.map(Stream::of).orElse(Stream.empty())).findFirst();
    }
}

