/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.util;

import com.github.triceo.robozonky.common.secrets.KeyStoreHandler;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class KeyStoreHandlerTest {
    private static File TARGET;
    private static final char[] PASSWORD;

    @BeforeClass
    public static void createTempFile() {
        try {
            TARGET = File.createTempFile("robozonky-", ".keystore");
            TARGET.delete();
            Assertions.assertThat((File)TARGET).doesNotExist();
        }
        catch (IOException e) {
            Assertions.fail((String)"Could not create temp file.", (Throwable)e);
        }
    }

    @Test
    public void storeSomethingAndReadIt() throws IOException, KeyStoreException {
        String key = "abc";
        String value = "def";
        Assertions.assertThat((File)TARGET).doesNotExist();
        KeyStoreHandler ksh = KeyStoreHandler.create((File)TARGET, (char[])PASSWORD);
        Assertions.assertThat((boolean)ksh.isDirty()).isFalse();
        Assertions.assertThat((File)TARGET).exists();
        boolean isStored = ksh.set("abc", "def".toCharArray());
        Assertions.assertThat((boolean)isStored).isTrue();
        Assertions.assertThat((boolean)ksh.isDirty()).isTrue();
        ksh.save();
        Assertions.assertThat((boolean)ksh.isDirty()).isFalse();
        Assertions.assertThat((Optional)ksh.get("abc")).isPresent();
        Assertions.assertThat((Optional)ksh.get("abc")).contains((Object)"def".toCharArray());
        KeyStoreHandler ksh2 = KeyStoreHandler.open((File)TARGET, (char[])PASSWORD);
        Assertions.assertThat((boolean)ksh2.isDirty()).isFalse();
        Assertions.assertThat((Optional)ksh2.get("abc")).isPresent();
        Assertions.assertThat((Optional)ksh2.get("abc")).contains((Object)"def".toCharArray());
        boolean isDeleted = ksh2.delete("abc");
        Assertions.assertThat((boolean)isDeleted).isTrue();
        Assertions.assertThat((boolean)ksh2.isDirty()).isTrue();
        Assertions.assertThat((Optional)ksh2.get("abc")).isEmpty();
    }

    static {
        PASSWORD = "AB\u0161 CD1234-".toCharArray();
    }
}

