/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.StringJoiner;

public class IoTestUtil {
    private static final String ROOT = new StringJoiner(File.separator).add("src").add("main").toString();

    public static File streamToFile(InputStream s) throws IOException {
        return IoTestUtil.streamToFile(s, ".tmp");
    }

    public static File streamToFile(InputStream fis, String extension) throws IOException {
        File f = File.createTempFile("robozonky-", extension);
        try (OutputStream fos = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            byte[] buffer = new byte[1024];
            int noOfBytes = 0;
            while ((noOfBytes = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, noOfBytes);
            }
        }
        return f;
    }

    public static String findMainSource() {
        File current = new File(System.getProperty("user.dir")).getAbsoluteFile();
        File f = new File(current, ROOT);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        File f2 = new File(current.getParent(), ROOT);
        if (f2.exists()) {
            return f2.getAbsolutePath();
        }
        throw new IllegalStateException("Oops.");
    }

    public static String findMainSource(String ... subfolders) {
        StringJoiner sj = new StringJoiner(File.separator);
        sj.add(IoTestUtil.findMainSource());
        Arrays.stream(subfolders).forEach(sj::add);
        return sj.toString();
    }
}

