/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.util;

import com.github.triceo.robozonky.util.FileUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class FileUtilsTest {
    @Test
    public void processFaultyFiles() {
        File f = (File)Mockito.mock(File.class);
        ((File)Mockito.doThrow(MalformedURLException.class).when((Object)f)).toURI();
        Assertions.assertThat((Iterable)FileUtils.filesToUrls((File[])new File[]{f})).isEmpty();
    }

    @Test
    public void lookupNonexistentFolder() {
        Assertions.assertThat((Optional)FileUtils.findFolder((String)"target")).isPresent();
    }

    @Test
    public void lookupExistingFileAsFolder() {
        Assertions.assertThat((Optional)FileUtils.findFolder((String)"pom.xml")).isEmpty();
    }

    @Test
    public void nullUrls() {
        Assertions.assertThat((Iterable)FileUtils.filesToUrls((File[])null)).isEmpty();
    }
}

