/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.secrets;

import com.github.triceo.robozonky.common.secrets.KeyStoreHandler;
import com.github.triceo.robozonky.common.secrets.KeyStoreSecretProvider;
import com.github.triceo.robozonky.common.secrets.SecretProvider;
import com.github.triceo.robozonky.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStoreException;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KeyStoreSecretProviderTest {
    private static final String USR = "username";
    private static final String PWD = "password";

    private static KeyStoreSecretProvider newMockProvider() {
        KeyStoreHandler ksh = (KeyStoreHandler)Mockito.mock(KeyStoreHandler.class);
        Mockito.when((Object)ksh.get((String)Mockito.any())).thenReturn(Optional.empty());
        return (KeyStoreSecretProvider)SecretProvider.keyStoreBased((KeyStoreHandler)ksh);
    }

    private static KeyStoreHandler getKeyStoreHandler() {
        try {
            File f = File.createTempFile("robozonky-", ".keystore");
            f.delete();
            return KeyStoreHandler.create((File)f, (char[])PWD.toCharArray());
        }
        catch (IOException | KeyStoreException e) {
            Assertions.fail((String)"Something went wrong.", (Throwable)e);
            return null;
        }
    }

    private static KeyStoreSecretProvider newProvider() {
        KeyStoreHandler ksh = KeyStoreSecretProviderTest.getKeyStoreHandler();
        return (KeyStoreSecretProvider)SecretProvider.keyStoreBased((KeyStoreHandler)ksh);
    }

    private static KeyStoreSecretProvider newProvider(String username, String password) {
        KeyStoreHandler ksh = KeyStoreSecretProviderTest.getKeyStoreHandler();
        return (KeyStoreSecretProvider)SecretProvider.keyStoreBased((KeyStoreHandler)ksh, (String)username, (char[])password.toCharArray());
    }

    @Test
    public void usernameNotSet() {
        Assertions.assertThatThrownBy(() -> KeyStoreSecretProviderTest.newMockProvider().getUsername()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void passwordNotSet() {
        Assertions.assertThatThrownBy(() -> KeyStoreSecretProviderTest.newMockProvider().getPassword()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void tokenNotSet() {
        KeyStoreSecretProvider p = KeyStoreSecretProviderTest.newMockProvider();
        Assertions.assertThat((Optional)p.getToken()).isEmpty();
    }

    @Test
    public void setUsernameAndPassword() {
        KeyStoreSecretProvider p = KeyStoreSecretProviderTest.newProvider(USR, PWD);
        Assertions.assertThat((String)p.getUsername()).isEqualTo((Object)USR);
        Assertions.assertThat((char[])p.getPassword()).isEqualTo((Object)PWD.toCharArray());
        String usr = "something";
        Assertions.assertThat((boolean)p.setUsername("something")).isTrue();
        Assertions.assertThat((String)p.getUsername()).isEqualTo((Object)"something");
        String pwd = "somethingElse";
        Assertions.assertThat((boolean)p.setPassword("somethingElse".toCharArray())).isTrue();
        Assertions.assertThat((char[])p.getPassword()).isEqualTo((Object)"somethingElse".toCharArray());
        String key = "key";
        String value = "value";
        Assertions.assertThat((boolean)p.setSecret("key", "value".toCharArray())).isTrue();
        Assertions.assertThat((Optional)p.getSecret("key")).contains((Object)"value".toCharArray());
        Assertions.assertThat((boolean)p.isPersistent()).isTrue();
    }

    @Test
    public void tokenManipulation() throws IOException {
        KeyStoreSecretProvider p = KeyStoreSecretProviderTest.newProvider();
        String toStore = "something";
        OffsetDateTime beforeStoring = OffsetDateTime.now();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertThat((boolean)p.setToken((Reader)new StringReader("something"))).isTrue();
        Assertions.assertThat((Optional)p.getToken()).isPresent();
        String stored = IOUtils.toString((Reader)((Reader)p.getToken().get()));
        Assertions.assertThat((String)stored).isEqualTo((Object)"something");
        p.deleteToken();
        Assertions.assertThat((Optional)p.getToken()).isEmpty();
    }

    @Test
    public void tokenDeleteFailed() throws IOException {
        KeyStoreHandler ksh = (KeyStoreHandler)Mockito.mock(KeyStoreHandler.class);
        ((KeyStoreHandler)Mockito.doThrow(IOException.class).when((Object)ksh)).save();
        KeyStoreSecretProvider p = new KeyStoreSecretProvider(ksh);
        Assertions.assertThat((boolean)p.deleteToken()).isFalse();
        ((KeyStoreHandler)Mockito.verify((Object)ksh, (VerificationMode)Mockito.times((int)1))).save();
        ((KeyStoreHandler)Mockito.verify((Object)ksh, (VerificationMode)Mockito.times((int)2))).delete((String)Mockito.any());
    }

    @Test
    public void tokenDeleteSucceeded() throws IOException {
        KeyStoreHandler ksh = (KeyStoreHandler)Mockito.mock(KeyStoreHandler.class);
        ((KeyStoreHandler)Mockito.doReturn((Object)true).when((Object)ksh)).delete((String)Mockito.any());
        KeyStoreSecretProvider p = new KeyStoreSecretProvider(ksh);
        Assertions.assertThat((boolean)p.deleteToken()).isTrue();
        ((KeyStoreHandler)Mockito.verify((Object)ksh, (VerificationMode)Mockito.times((int)1))).save();
        ((KeyStoreHandler)Mockito.verify((Object)ksh, (VerificationMode)Mockito.times((int)2))).delete((String)Mockito.any());
    }

    @Test
    public void tokenSaveFailed() throws IOException {
        KeyStoreHandler ksh = (KeyStoreHandler)Mockito.mock(KeyStoreHandler.class);
        ((KeyStoreHandler)Mockito.doThrow(IOException.class).when((Object)ksh)).save();
        KeyStoreSecretProvider p = new KeyStoreSecretProvider(ksh);
        Assertions.assertThat((boolean)p.setToken((Reader)new StringReader("something"))).isFalse();
        ((KeyStoreHandler)Mockito.verify((Object)ksh, (VerificationMode)Mockito.atLeast((int)1))).save();
        ((KeyStoreHandler)Mockito.verify((Object)ksh, (VerificationMode)Mockito.times((int)2))).set((String)Mockito.any(), (char[])Mockito.any(char[].class));
    }

    @Test
    public void noKeyStoreHandlerProvided() {
        Assertions.assertThatThrownBy(() -> new KeyStoreSecretProvider(null)).isInstanceOf(IllegalArgumentException.class);
    }
}

