/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.strategies.InvestmentStrategy;
import com.github.triceo.robozonky.api.strategies.InvestmentStrategyService;
import com.github.triceo.robozonky.common.extensions.InvestmentStrategyLoader;
import java.io.InputStream;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class InvestmentStrategyLoaderTest {
    @Test
    public void unknown() {
        Optional result = InvestmentStrategyLoader.load((String)UUID.randomUUID().toString());
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    public void failedProcessing() {
        InvestmentStrategyService iss = (InvestmentStrategyService)Mockito.mock(InvestmentStrategyService.class);
        ((InvestmentStrategyService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Testing")}).when((Object)iss)).parse((InputStream)ArgumentMatchers.any());
        Assertions.assertThat((Optional)InvestmentStrategyLoader.processInvestmentStrategyService((InvestmentStrategyService)iss, (String)"")).isEmpty();
    }

    @Test
    public void standardProcessing() {
        InvestmentStrategyService iss = (InvestmentStrategyService)Mockito.mock(InvestmentStrategyService.class);
        Mockito.when((Object)iss.parse((InputStream)ArgumentMatchers.any())).thenReturn(Optional.of(Mockito.mock(InvestmentStrategy.class)));
        Assertions.assertThat((Optional)InvestmentStrategyLoader.processInvestmentStrategyService((InvestmentStrategyService)iss, (String)"")).isPresent();
    }
}

