/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.notifications.ListenerService;
import com.github.triceo.robozonky.common.extensions.ExtensionsManager;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ServiceLoader;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ExtensionsManagerTest {
    private static final ClassLoader CLASSLOADER = ExtensionsManager.class.getClassLoader();

    @Test
    public void retrieveDefaultClassLoader() {
        ClassLoader result = ExtensionsManager.INSTANCE.retrieveExtensionClassLoader("");
        Assertions.assertThat((Object)result).isSameAs((Object)CLASSLOADER);
    }

    @Test
    public void noExtensionsWithFolderPresent() {
        ServiceLoader result = ExtensionsManager.INSTANCE.getServiceLoader(ListenerService.class);
        Assertions.assertThat((Iterable)result).isNotNull();
    }

    @Test
    public void noExtensionsWithFolderMissing() {
        ServiceLoader result = ExtensionsManager.INSTANCE.getServiceLoader(ListenerService.class, UUID.randomUUID().toString());
        Assertions.assertThat((Iterable)result).isNotNull();
    }

    @Test
    public void loadJarsFromFolderWithJars() {
        File f = new File("target");
        Assertions.assertThat((Object)ExtensionsManager.INSTANCE.retrieveExtensionClassLoader(f)).isInstanceOf(URLClassLoader.class);
    }

    @Test
    public void loadJarsFromFolderWithNoJars() {
        File f = new File("src");
        Assertions.assertThat((Object)ExtensionsManager.INSTANCE.retrieveExtensionClassLoader(f)).isInstanceOf(URLClassLoader.class);
    }
}

