/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.robozonky.common.extensions;

import com.github.triceo.robozonky.api.Refreshable;
import com.github.triceo.robozonky.api.confirmations.Confirmation;
import com.github.triceo.robozonky.api.confirmations.ConfirmationProvider;
import com.github.triceo.robozonky.api.confirmations.ConfirmationType;
import com.github.triceo.robozonky.api.confirmations.RequestId;
import com.github.triceo.robozonky.api.notifications.Event;
import com.github.triceo.robozonky.api.notifications.EventListener;
import com.github.triceo.robozonky.api.notifications.RoboZonkyTestingEvent;
import com.github.triceo.robozonky.api.remote.ZonkyApi;
import com.github.triceo.robozonky.api.remote.entities.Loan;
import com.github.triceo.robozonky.common.extensions.Checker;
import com.github.triceo.robozonky.common.remote.ApiProvider;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CheckerTest {
    @Test
    public void confirmationsMarketplaceFail() {
        ApiProvider provider = (ApiProvider)Mockito.mock(ApiProvider.class);
        ((ApiProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Testing")}).when((Object)provider)).anonymous();
        Optional result = Checker.confirmations((ConfirmationProvider)((ConfirmationProvider)Mockito.mock(ConfirmationProvider.class)), (String)"", (char[])new char[0], () -> provider);
        ((OptionalAssert)Assertions.assertThat((Optional)result).isPresent()).hasValue((Object)false);
    }

    @Test
    public void confirmationsMarketplaceWithoutLoans() {
        ZonkyApi api = (ZonkyApi)Mockito.mock(ZonkyApi.class);
        Mockito.when((Object)api.getLoans()).thenReturn(Collections.emptyList());
        ApiProvider provider = (ApiProvider)Mockito.mock(ApiProvider.class);
        Mockito.when((Object)provider.anonymous()).thenReturn((Object)new ApiProvider.ApiWrapper(ZonkyApi.class, (Object)api));
        Optional result = Checker.confirmations((ConfirmationProvider)((ConfirmationProvider)Mockito.mock(ConfirmationProvider.class)), (String)"", (char[])new char[0], () -> provider);
        ((OptionalAssert)Assertions.assertThat((Optional)result).isPresent()).hasValue((Object)false);
    }

    private static ApiProvider mockApiThatReturnsOneLoan() {
        Loan l = (Loan)Mockito.mock(Loan.class);
        ZonkyApi api = (ZonkyApi)Mockito.mock(ZonkyApi.class);
        ((ZonkyApi)Mockito.doReturn(Collections.singletonList(l)).when((Object)api)).getLoans();
        ApiProvider provider = (ApiProvider)Mockito.mock(ApiProvider.class);
        ((ApiProvider)Mockito.doReturn((Object)new ApiProvider.ApiWrapper(ZonkyApi.class, (Object)api)).when((Object)provider)).anonymous();
        return provider;
    }

    @Test
    public void confirmationsNotConfirming() {
        ConfirmationProvider cp = (ConfirmationProvider)Mockito.mock(ConfirmationProvider.class);
        Mockito.when((Object)cp.requestConfirmation((RequestId)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(Optional.empty());
        Optional result = Checker.confirmations((ConfirmationProvider)cp, (String)"", (char[])new char[0], () -> CheckerTest.mockApiThatReturnsOneLoan());
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    public void confirmationsRejecting() {
        ConfirmationProvider cp = (ConfirmationProvider)Mockito.mock(ConfirmationProvider.class);
        Mockito.when((Object)cp.requestConfirmation((RequestId)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(new Confirmation(ConfirmationType.REJECTED)));
        Optional result = Checker.confirmations((ConfirmationProvider)cp, (String)"", (char[])new char[0], () -> CheckerTest.mockApiThatReturnsOneLoan());
        ((OptionalAssert)Assertions.assertThat((Optional)result).isPresent()).hasValue((Object)false);
    }

    @Test
    public void confirmationsProper() {
        ConfirmationProvider cp = (ConfirmationProvider)Mockito.mock(ConfirmationProvider.class);
        Mockito.when((Object)cp.requestConfirmation((RequestId)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(new Confirmation(ConfirmationType.DELEGATED)));
        Optional result = Checker.confirmations((ConfirmationProvider)cp, (String)"", (char[])new char[0], () -> CheckerTest.mockApiThatReturnsOneLoan());
        ((OptionalAssert)Assertions.assertThat((Optional)result).isPresent()).hasValue((Object)true);
    }

    @Test
    public void notificationsEmptyOnInput() {
        Assertions.assertThat((boolean)Checker.notifications(Collections.emptyList())).isFalse();
    }

    @Test
    public void notificationsEmptyWhenRefreshed() {
        Refreshable r = Refreshable.createImmutable(null);
        r.run();
        Assertions.assertThat((boolean)Checker.notifications(Collections.singletonList(r))).isFalse();
    }

    @Test
    public void notificationsProper() {
        EventListener l = (EventListener)Mockito.mock(EventListener.class);
        Refreshable r = Refreshable.createImmutable((Object)l);
        r.run();
        Assertions.assertThat((boolean)Checker.notifications(Collections.singletonList(r))).isTrue();
        ((EventListener)Mockito.verify((Object)l)).handle((Event)ArgumentMatchers.any(RoboZonkyTestingEvent.class));
    }
}

