/*
 * Decompiled with CFR 0.152.
 */
package com.github.trecloux.yeoman;

import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class YeomanMojo
extends AbstractMojo {
    @Parameter(defaultValue="yo", required=true)
    File yeomanProjectDirectory;
    @Parameter(defaultValue="${os.name}", readonly=true)
    String osName;
    @Parameter(property="yo.build.skip", defaultValue="false")
    boolean skipBuild;
    @Parameter(property="yo.test.skip", defaultValue="false")
    boolean skipTests;
    @Parameter(property="yo.skip", defaultValue="false")
    boolean skip;
    @Parameter(defaultValue="install", required=true)
    String npmInstallArgs;
    @Parameter(defaultValue="bower", required=true)
    String bowerVariant;
    @Parameter(defaultValue="install --no-color", required=true)
    String bowerInstallArgs;
    @Parameter(defaultValue="grunt", required=true)
    String buildTool;
    @Parameter(defaultValue="test --no-color", required=true)
    String testArgs;
    @Parameter(defaultValue="build --no-color", required=true)
    String buildArgs;
    @Deprecated
    @Parameter(required=false)
    String gruntTestArgs;
    @Deprecated
    @Parameter(required=false)
    String gruntBuildArgs;

    public void execute() throws MojoExecutionException {
        this.handleDeprecatedParameters();
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Yeoman Execution");
        } else {
            this.npmInstall();
            this.bowerInstall();
            this.build();
        }
    }

    private void handleDeprecatedParameters() {
        if (this.gruntTestArgs != null) {
            this.testArgs = this.gruntTestArgs;
        }
        if (this.gruntBuildArgs != null) {
            this.buildArgs = this.gruntBuildArgs;
        }
    }

    void npmInstall() throws MojoExecutionException {
        this.logToolVersion("node");
        this.logToolVersion("npm");
        this.logAndExecuteCommand("npm " + this.npmInstallArgs);
    }

    void bowerInstall() throws MojoExecutionException {
        this.logToolVersion(this.bowerVariant);
        this.logAndExecuteCommand(this.bowerVariant + " " + this.bowerInstallArgs);
    }

    void build() throws MojoExecutionException {
        this.logToolVersion(this.buildTool);
        if (!this.skipTests) {
            this.logAndExecuteCommand(this.buildTool + " " + this.testArgs);
        }
        if (!this.skipBuild) {
            this.logAndExecuteCommand(this.buildTool + " " + this.buildArgs);
        }
    }

    void logToolVersion(String toolName) throws MojoExecutionException {
        this.getLog().info((CharSequence)(toolName + " version :"));
        this.executeCommand(toolName + " --version");
    }

    void logAndExecuteCommand(String command) throws MojoExecutionException {
        this.logCommand(command);
        this.executeCommand(command);
    }

    void logCommand(String command) {
        this.getLog().info((CharSequence)"--------------------------------------");
        this.getLog().info((CharSequence)("         " + command.toUpperCase()));
        this.getLog().info((CharSequence)"--------------------------------------");
    }

    void executeCommand(String command) throws MojoExecutionException {
        try {
            if (this.isWindows()) {
                command = "cmd /c " + command;
            }
            CommandLine cmdLine = CommandLine.parse((String)command);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.yeomanProjectDirectory);
            executor.execute(cmdLine);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during : " + command, (Exception)e);
        }
    }

    private boolean isWindows() {
        return this.osName.startsWith("Windows");
    }
}

