/*
 * Decompiled with CFR 0.152.
 */
package cl.transbank.util;

import cl.transbank.common.IntegrationTypeHelper;
import cl.transbank.exception.TransbankException;
import cl.transbank.model.Options;
import cl.transbank.model.WebpayApiRequest;
import cl.transbank.util.HttpUtil;
import cl.transbank.util.HttpUtilImpl;
import cl.transbank.webpay.common.WebpayOptions;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class WebpayApiResource {
    private static HttpUtil httpUtil = HttpUtilImpl.getInstance();

    public static Map<String, String> buildHeaders(Options options) {
        if (null == options) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(options.getHeaderCommerceCodeName(), options.getCommerceCode());
        headers.put(options.getHeaderApiKeyName(), options.getApiKey());
        return headers;
    }

    public static <T> T execute(String endpoint, HttpUtil.RequestMethod method, Options options, Class<T> clazz) throws TransbankException, IOException {
        return WebpayApiResource.execute(endpoint, method, null, options, clazz);
    }

    public static <T> T execute(String endpoint, HttpUtil.RequestMethod method, WebpayApiRequest request, Options options) throws TransbankException, IOException {
        return WebpayApiResource.execute(endpoint, method, request, options, null);
    }

    public static <T> T execute(String endpoint, HttpUtil.RequestMethod method, WebpayApiRequest request, Options options, Class<T> clazz) throws TransbankException, IOException {
        String urlBase = null;
        urlBase = options instanceof WebpayOptions ? IntegrationTypeHelper.getWebpayIntegrationType(options.getIntegrationType()) : IntegrationTypeHelper.getPatpassIntegrationType(options.getIntegrationType());
        URL url = new URL(String.format("%s/%s", urlBase, endpoint));
        T out = WebpayApiResource.getHttpUtil().request(url, method, request, WebpayApiResource.buildHeaders(options), clazz);
        if (null == out) {
            return null;
        }
        if (null == clazz) {
            return null;
        }
        return out;
    }

    public static HttpUtil getHttpUtil() {
        return httpUtil;
    }

    public static void setHttpUtil(HttpUtil httpUtil) {
        WebpayApiResource.httpUtil = httpUtil;
    }
}

