/*
 * Decompiled with CFR 0.152.
 */
package cl.transbank.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MallTransactionCreateDetails {
    private List<Detail> detailList = new ArrayList<Detail>();

    private MallTransactionCreateDetails() {
    }

    public static MallTransactionCreateDetails build() {
        return new MallTransactionCreateDetails();
    }

    public static MallTransactionCreateDetails build(double amount, String commerceCode, String buyOrder) {
        return MallTransactionCreateDetails.build().add(amount, commerceCode, buyOrder);
    }

    public MallTransactionCreateDetails add(double amount, String commerceCode, String buyOrder) {
        this.detailList.add(new Detail(amount, commerceCode, buyOrder));
        return this;
    }

    public boolean remove(double amount, String commerceCode, String buyOrder) {
        return this.getDetails().remove(new Detail(amount, commerceCode, buyOrder));
    }

    public List<Detail> getDetails() {
        return Collections.unmodifiableList(this.detailList);
    }

    public class Detail {
        private double amount;
        private String commerceCode;
        private String buyOrder;

        public boolean equals(Object obj) {
            if (!(obj instanceof Detail)) {
                return false;
            }
            Detail another = (Detail)obj;
            return this.getAmount() == another.getAmount() && this.getCommerceCode().equals(another.getBuyOrder()) && this.getBuyOrder().equals(another.getBuyOrder());
        }

        public Detail() {
        }

        public Detail(double amount, String commerceCode, String buyOrder) {
            this.amount = amount;
            this.commerceCode = commerceCode;
            this.buyOrder = buyOrder;
        }

        public double getAmount() {
            return this.amount;
        }

        public String getCommerceCode() {
            return this.commerceCode;
        }

        public String getBuyOrder() {
            return this.buyOrder;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public void setCommerceCode(String commerceCode) {
            this.commerceCode = commerceCode;
        }

        public void setBuyOrder(String buyOrder) {
            this.buyOrder = buyOrder;
        }

        public String toString() {
            return "MallTransactionCreateDetails.Detail(amount=" + this.getAmount() + ", commerceCode=" + this.getCommerceCode() + ", buyOrder=" + this.getBuyOrder() + ")";
        }
    }
}

