/* Generated By:JavaCC: Do not edit this line. PDDL21parser.java */
package javaff.parser;

import javaff.JavaFF;
import javaff.data.*;
import javaff.data.strips.*;
import javaff.data.metric.*;
import javaff.data.temporal.*;

import java.io.PrintStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.Hashtable;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import java.math.BigDecimal;

public class PDDL21parser implements PDDL21parserConstants {
        protected static UngroundProblem UP = new UngroundProblem();

    public static UngroundProblem parseFiles(File pDomainFile, File pProblemFile)
    {
                boolean probsuc = false;
                boolean suc = parseDomainFile(pDomainFile);
                if (suc) probsuc = parseProblemFile(pProblemFile);
                if (probsuc) return UP;
                else return null;
    }

    private static boolean parseDomainFile(File pFile)
    {
                boolean req = false;
        try
        {
            FileReader tFileReader = new FileReader(pFile);
                        PDDL21parser parser = new PDDL21parser(tFileReader);
            req = parser.parseDomain();
            tFileReader.close();
                }
                catch (FileNotFoundException e)
                {
            JavaFF.parsingOutput.println("File "+pFile+" has not been found");
            req = false;
                }
                catch (IOException e)
                {
            JavaFF.parsingOutput.println("Unknown IOException caught");
            JavaFF.parsingOutput.println(e.getMessage());
            req = false;
                }
        catch (ParseException e)
        {
            JavaFF.parsingOutput.println("Error whilst parsing file "+pFile);
            JavaFF.parsingOutput.println(e.getMessage());
            req = false;
        }
        if (req) JavaFF.parsingOutput.println("Parsed Domain file "+pFile+" successfully");
                else JavaFF.parsingOutput.println("Parsing of Domain file "+pFile+" failed");
                return req;
    }

    private static boolean parseProblemFile(File pFile)
    {
                boolean probsuc = true;
        try
        {
            FileReader tFileReader = new FileReader(pFile);
                        PDDL21parser parser = new PDDL21parser(tFileReader);
            parser.parseProblem();
            tFileReader.close();
                }
                catch (FileNotFoundException e)
                {
            JavaFF.parsingOutput.println("File "+pFile+" has not been found");
            probsuc = false;
                }
                catch (IOException e)
                {
            JavaFF.parsingOutput.println("Unknown IOException caught");
            JavaFF.parsingOutput.println(e.getMessage());
            probsuc = false;
                }
        catch (ParseException e)
        {
            JavaFF.parsingOutput.println("Error whilst parsing file "+pFile);
            JavaFF.parsingOutput.println(e.getMessage());
            probsuc = false;
        }
        if (probsuc) JavaFF.parsingOutput.println("Parsed Problem file "+pFile+" successfully");
                else JavaFF.parsingOutput.println("Parsing Problem file "+pFile+" failed");
                return probsuc;
    }

        private class TypedList
        {
                public List objects = new ArrayList();
                public Map types = new Hashtable();    // Maps strings onto Types

                public void add(String s)
                {
                        objects.add(s);
                        types.put(s,SimpleType.rootType);
                }

                public void add(String s, Type t)
                {
                        objects.add(s);
                        types.put(s,t);
                }
        }

// ******************************************************************************
// *																			*
// * 							Parse the Domain File							*
// *																			*
// ******************************************************************************
  final public boolean parseDomain() throws ParseException {
    Token t;
        boolean req = true;
    jj_consume_token(OPEN);
    jj_consume_token(DEFINE);
    jj_consume_token(OPEN);
    jj_consume_token(DOMAIN);
    t = jj_consume_token(NAME);
    jj_consume_token(CLOSE);
                UP.DomainName = t.toString();
    if (jj_2_1(20)) {
      req = parseRequireDef();
    } else {
      ;
    }
         if (!req) {if (true) return false;}
    if (jj_2_2(20)) {
      parseTypeDef();
    } else {
      ;
    }
    if (jj_2_3(20)) {
      parseConstantsDef();
    } else {
      ;
    }
    if (jj_2_4(20)) {
      parsePredicatesDef();
    } else {
      ;
    }
    if (jj_2_5(20)) {
      parseFunctionsDef();
    } else {
      ;
    }
    label_1:
    while (true) {
      if (jj_2_6(20)) {
        ;
      } else {
        break label_1;
      }
      parseStructureDef();
    }
    jj_consume_token(CLOSE);
    jj_consume_token(0);
         {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse the requirement definitions
// ***************************************************
  final public boolean parseRequireDef() throws ParseException {
        Token t;
    jj_consume_token(OPEN);
    jj_consume_token(REQUIREMENTS);
    label_2:
    while (true) {
      if (jj_2_7(20)) {
        ;
      } else {
        break label_2;
      }
      if (jj_2_8(20)) {
        t = jj_consume_token(REQUIREMENT_LABELS);
                                                       UP.requirements.add(t.toString());
      } else if (jj_2_9(20)) {
        t = jj_consume_token(NON_HANDLED_LABELS);
                                                                                                                       JavaFF.parsingOutput.println("cannnot parse "+t.toString()); {if (true) return false;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(CLOSE);
                                                                                                                                                                                                               {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse the type definitions
// ***************************************************
  final public void parseTypeDef() throws ParseException {
    Type t;
        Set types;
    jj_consume_token(OPEN);
    jj_consume_token(TYPES);
    label_3:
    while (true) {
      if (jj_2_10(20)) {
        ;
      } else {
        break label_3;
      }
          types = new HashSet();
      label_4:
      while (true) {
        t = parsePrimitiveType();
          types.add(t);
        if (jj_2_11(20)) {
          ;
        } else {
          break label_4;
        }
      }
      jj_consume_token(TYPE_IDENT);
      t = parseType();
                Iterator tit = types.iterator();
                while (tit.hasNext())
                {
                        SimpleType type = (SimpleType) tit.next();
                        type.setSuperType(t);
                }
    }
    label_5:
    while (true) {
      if (jj_2_12(20)) {
        ;
      } else {
        break label_5;
      }
      t = parsePrimitiveType();
    }
    jj_consume_token(CLOSE);
  }

  final public Type parseType() throws ParseException {
        Type t;
    if (jj_2_13(20)) {
      t = parsePrimitiveType();
    } else if (jj_2_14(20)) {
      t = parseEitherType();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public SimpleType parsePrimitiveType() throws ParseException {
        Token t;
    t = jj_consume_token(NAME);
                String typeStr = t.toString().toLowerCase();
                SimpleType type = (SimpleType) UP.typeMap.get(typeStr);
                if (type == null)
                {
                        type = new SimpleType(typeStr);
                        UP.types.add(type);
                        UP.typeMap.put(typeStr, type);
                }
                {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public EitherType parseEitherType() throws ParseException {
        EitherType et = new EitherType();
        SimpleType st;
    jj_consume_token(OPEN);
    jj_consume_token(EITHER);
    label_6:
    while (true) {
      st = parsePrimitiveType();
                                                     et.addType(st);
      if (jj_2_15(20)) {
        ;
      } else {
        break label_6;
      }
    }
    jj_consume_token(CLOSE);
          {if (true) return et;}
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse a TypedList
// ***************************************************
  final public TypedList parseTypedList() throws ParseException {
    List strings = new ArrayList();
        Type type;
    Token t;
    TypedList rList = new TypedList();
    TypedList tList;
    if (jj_2_22(20)) {
      label_7:
      while (true) {
        if (jj_2_16(20)) {
          t = jj_consume_token(NAME);
        } else if (jj_2_17(20)) {
          t = jj_consume_token(VAR);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      strings.add(t.toString());
        if (jj_2_18(20)) {
          ;
        } else {
          break label_7;
        }
      }
      jj_consume_token(TYPE_IDENT);
      type = parseType();
                Iterator tit = strings.iterator();
                while (tit.hasNext())
                {
                        String string = (String) tit.next();
                        rList.add(string, type);
                }
      tList = parseTypedList();
                        rList.objects.addAll(tList.objects);
                        rList.types.putAll(tList.types);
    } else {
      label_8:
      while (true) {
        if (jj_2_19(20)) {
          ;
        } else {
          break label_8;
        }
        if (jj_2_20(20)) {
          t = jj_consume_token(NAME);
        } else if (jj_2_21(20)) {
          t = jj_consume_token(VAR);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
                               rList.add(t.toString());
      }
    }
                {if (true) return rList;}
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse the constants
// ***************************************************
  final public void parseConstantsDef() throws ParseException {
        TypedList tl;
    jj_consume_token(OPEN);
    jj_consume_token(CONSTANTS);
    tl = parseTypedList();
    jj_consume_token(CLOSE);
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        PDDLObject c =  new PDDLObject(str);
                        c.setType((Type)tl.types.get(str));
                        UP.constants.add(c);
                        UP.constantMap.put(str, c);
                }
  }

// ***************************************************
// *	Parse the predicates
// ***************************************************
  final public void parsePredicatesDef() throws ParseException {
    jj_consume_token(OPEN);
    jj_consume_token(PREDICATES);
    label_9:
    while (true) {
      parsePredicate();
      if (jj_2_23(20)) {
        ;
      } else {
        break label_9;
      }
    }
    jj_consume_token(CLOSE);
  }

  final public void parsePredicate() throws ParseException {
    PredicateSymbol ps;
        TypedList tl;
    jj_consume_token(OPEN);
    ps = parsePredicateSymbol();
    tl = parseTypedList();
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        Variable v =  new Variable(str);
                        v.setType((Type)tl.types.get(str));
                        ps.addVar(v);
                }
                UP.predSymbols.add(ps);
    jj_consume_token(CLOSE);
  }

  final public PredicateSymbol parsePredicateSymbol() throws ParseException {
    Token t;
    t = jj_consume_token(NAME);
                PredicateSymbol ps = (PredicateSymbol) UP.predSymbolMap.get(t.toString());
                if (ps == null)
                {
                        ps = new PredicateSymbol(t.toString());
                        UP.predSymbolMap.put(t.toString(), ps);
                }
                {if (true) return ps;}
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse a STRIPS action
// ***************************************************
  final public void parseStructureDef() throws ParseException {
    if (jj_2_24(20)) {
      parseActionDef();
    } else if (jj_2_25(20)) {
      parseDurActionDef();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parseActionDef() throws ParseException {
    UngroundInstantAction a = new UngroundInstantAction();
    TypedList tl;
        Map varMap = new Hashtable();
    jj_consume_token(OPEN);
    jj_consume_token(ACTION);
    a.name = parseOperatorName();
    jj_consume_token(PARAMETERS);
    jj_consume_token(OPEN);
    tl = parseTypedList();
    jj_consume_token(CLOSE);
                UP.actions.add(a);
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        Variable v = new Variable(str);
                        v.setType((Type) tl.types.get(str));
                        a.params.add(v);
                        varMap.put(str,v);
                }
    parseActionDefBody(a, varMap);
    jj_consume_token(CLOSE);
  }

  final public OperatorName parseOperatorName() throws ParseException {
    Token t;
    t = jj_consume_token(NAME);
              {if (true) return new OperatorName(t.toString());}
    throw new Error("Missing return statement in function");
  }

  final public void parseActionDefBody(UngroundInstantAction a, Map varMap) throws ParseException {
        Condition c;
        Effect e;
    if (jj_2_26(20)) {
      jj_consume_token(PRECONDITION);
      c = parseGD(varMap, false);
                                                  a.condition = (UngroundCondition) c;
    } else {
      ;
    }
    if (jj_2_27(20)) {
      jj_consume_token(EFFECT);
      e = parseEffect(varMap);
                                         a.effect = (UngroundEffect) e;
    } else {
      ;
    }
  }

// **********************************
// *	Parse Goal Definition
// **********************************

// Map m is the variableMap
// boolean ground is wheather it is ground or not (i.e. in an action or in the initial state)
  final public Condition parseGD(Map m, boolean ground) throws ParseException {
        Literal p;
        Condition c;
        AND and;
    if (jj_2_29(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(CLOSE);
                          {if (true) return TrueCondition.getInstance();}
    } else if (jj_2_30(20)) {
      p = parseAtomicFormula(m, ground);
                                            {if (true) return p;}
    } else if (jj_2_31(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AND);
                       and = new AND();
      label_10:
      while (true) {
        if (jj_2_28(20)) {
          ;
        } else {
          break label_10;
        }
        c = parseGD(m, ground);
                                                                   and.add(c);
      }
      jj_consume_token(CLOSE);
                                                                                            {if (true) return and;}
    } else if (jj_2_32(20)) {
      c = parseFComp(m);
                            {if (true) return c;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Literal parseAtomicFormula(Map m, boolean ground) throws ParseException {
        PredicateSymbol p;
        TypedList tl;
    jj_consume_token(OPEN);
    p = parsePredicateSymbol();
    tl = parseTypedList();
    jj_consume_token(CLOSE);
                Literal lit;
                if (ground) lit = new Proposition(p);
                else lit = new Predicate(p);
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        Parameter o = null;
                        if (m != null) o = (Parameter) m.get(str);
            if (o == null) o = (Parameter) UP.constantMap.get(str);
            if (o == null) o = (Parameter) UP.objectMap.get(str);
                        lit.addParameter(o);
                }
                {if (true) return lit;}
    throw new Error("Missing return statement in function");
  }

// **********************************
// *	Parse Effect
// **********************************
  final public Effect parseEffect(Map m) throws ParseException {
        Effect c;
        AND and;
    if (jj_2_34(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(CLOSE);
                          {if (true) return NullEffect.getInstance();}
    } else if (jj_2_35(20)) {
      c = parseCEffect(m);
                               {if (true) return c;}
    } else if (jj_2_36(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AND);
                       and = new AND();
      label_11:
      while (true) {
        if (jj_2_33(20)) {
          ;
        } else {
          break label_11;
        }
        c = parseCEffect(m);
                                                                and.add(c);
      }
      jj_consume_token(CLOSE);
                                                                                         {if (true) return and;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Effect parseCEffect(Map m) throws ParseException {
        Effect p;
    p = parsePEffect(m);
                             {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public Effect parsePEffect(Map m) throws ParseException {
        Literal p;
        ResourceOperator ro;
    if (jj_2_37(20)) {
      p = parseAtomicFormula(m, false);
                                           {if (true) return p;}
    } else if (jj_2_38(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(NOT);
      p = parseAtomicFormula(m, false);
      jj_consume_token(CLOSE);
                                                                {if (true) return new NOT(p);}
    } else if (jj_2_39(20)) {
      ro = parseResourceOperator(m);
                                       {if (true) return ro;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse Metrics
// ***************************************************


// **********************************
// *	Parse Function Definitions
// **********************************
  final public void parseFunctionsDef() throws ParseException {
        TypedList tl;
    jj_consume_token(OPEN);
    jj_consume_token(FUNCTIONS);
    label_12:
    while (true) {
      parseFunctionSkeleton();
      if (jj_2_40(20)) {
        ;
      } else {
        break label_12;
      }
    }
    jj_consume_token(CLOSE);
  }

  final public void parseFunctionSkeleton() throws ParseException {
    FunctionSymbol fs;
        TypedList tl;
    jj_consume_token(OPEN);
    fs = parseFunctionSymbol();
    tl = parseTypedList();
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        Variable v =  new Variable(str);
                        v.setType((Type)tl.types.get(str));
                        fs.addVar(v);
                }
                UP.funcSymbols.add(fs);
    jj_consume_token(CLOSE);
  }

  final public FunctionSymbol parseFunctionSymbol() throws ParseException {
    Token t;
    t = jj_consume_token(NAME);
                FunctionSymbol fs = (FunctionSymbol) UP.funcSymbolMap.get(t.toString());
                if (fs == null)
                {
                        fs = new FunctionSymbol(t.toString());
                        UP. funcSymbolMap.put(t.toString(), fs);
                }
                {if (true) return fs;}
    throw new Error("Missing return statement in function");
  }

// **********************************
// *	Parse Function Comparators
// **********************************
  final public BinaryComparator parseFComp(Map varMap) throws ParseException {
        Token t1;
        Function f1, f2;
    jj_consume_token(OPEN);
    t1 = jj_consume_token(BINARY_COMP);
    f1 = parseFExp(varMap);
    f2 = parseFExp(varMap);
    jj_consume_token(CLOSE);
                BinaryComparator bc = new BinaryComparator(t1.toString(), f1, f2);
                {if (true) return bc;}
    throw new Error("Missing return statement in function");
  }

  final public Function parseFExp(Map varMap) throws ParseException {
        Token t1;
        Function f1, f2;
    if (jj_2_41(20)) {
      t1 = jj_consume_token(NUMBER);
                        {if (true) return new NumberFunction(Double.parseDouble(t1.toString()));}
    } else if (jj_2_42(20)) {
      jj_consume_token(OPEN);
      t1 = jj_consume_token(BINARY_OP);
      f1 = parseFExp(varMap);
      f2 = parseFExp(varMap);
      jj_consume_token(CLOSE);
                BinaryFunction bf = new BinaryFunction(t1.toString(), f1, f2);
                {if (true) return bf;}
    } else if (jj_2_43(20)) {
      jj_consume_token(OPEN);
      t1 = jj_consume_token(TYPE_IDENT);
      f1 = parseFExp(varMap);
      f2 = parseFExp(varMap);
      jj_consume_token(CLOSE);
                BinaryFunction bf = new BinaryFunction(t1.toString(), f1, f2);
                {if (true) return bf;}
    } else if (jj_2_44(20)) {
      jj_consume_token(OPEN);
      t1 = jj_consume_token(TYPE_IDENT);
      f1 = parseFExp(varMap);
      jj_consume_token(CLOSE);
                BinaryFunction bf = new BinaryFunction(t1.toString(), new NumberFunction(0), f1);
                {if (true) return bf;}
    } else if (jj_2_45(20)) {
      f1 = parseFHead(varMap);
                                  {if (true) return f1;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public NamedFunction parseFHead(Map varMap) throws ParseException {
        FunctionSymbol f;
        TypedList tl;
    if (jj_2_48(20)) {
      jj_consume_token(OPEN);
      f = parseFunctionSymbol();
      tl = parseTypedList();
      jj_consume_token(CLOSE);
                NamedFunction nf = new NamedFunction(f);
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        Parameter o = null;
                        if (varMap != null) o = (Parameter) varMap.get(str);
            if (o == null) o = (Parameter) UP.constantMap.get(str);
            if (o == null) o = (Parameter) UP.objectMap.get(str);
                        nf.addParameter(o);
                }
                {if (true) return nf;}
    } else if (jj_2_49(20)) {
      if (jj_2_46(20)) {
        jj_consume_token(OPEN);
      } else {
        ;
      }
      jj_consume_token(TOTAL_TIME);
      if (jj_2_47(20)) {
        jj_consume_token(CLOSE);
      } else {
        ;
      }
                                             {if (true) return TotalTimeFunction.getInstance();}
    } else if (jj_2_50(20)) {
      f = parseFunctionSymbol();
                NamedFunction nf = new NamedFunction(f);
                {if (true) return nf;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// **********************************
// *	Parse Resource Operators
// **********************************
  final public ResourceOperator parseResourceOperator(Map varMap) throws ParseException {
        Token t1;
        NamedFunction f1;
        Function f2;
    jj_consume_token(OPEN);
    t1 = jj_consume_token(ASSIGN_OP);
    f1 = parseFHead(varMap);
    f2 = parseFExp(varMap);
    jj_consume_token(CLOSE);
                {if (true) return new ResourceOperator(t1.toString(), f1, f2);}
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse Temporal
// ***************************************************

// **********************************
// *	Parse Durative Action
// **********************************
  final public void parseDurActionDef() throws ParseException {
    UngroundDurativeAction a = new UngroundDurativeAction();
    TypedList tl;
        Map varMap = new Hashtable();
    jj_consume_token(OPEN);
    jj_consume_token(DURATIVE_ACTION);
    a.name = parseOperatorName();
    jj_consume_token(PARAMETERS);
    jj_consume_token(OPEN);
    tl = parseTypedList();
    jj_consume_token(CLOSE);
                UP.actions.add(a);
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        Variable v = new Variable(str);
                        v.setType((Type) tl.types.get(str));
                        a.params.add(v);
                        varMap.put(str,v);
                }
    parseDurativeActionDefBody(a, varMap);
                                               a.makeInstants();
    jj_consume_token(CLOSE);
  }

  final public void parseDurativeActionDefBody(UngroundDurativeAction da, Map varMap) throws ParseException {
        DurationConstraint dc;
    jj_consume_token(DURATION);
    dc = parseDurationConstraint(da, varMap);
                                                           da.durationConstraint = dc;
    jj_consume_token(CONDITION);
    parseDAGD(da, varMap);
    jj_consume_token(EFFECT);
    parseDAEffect(da, varMap);
  }

// **********************************
// *	Parse Durative Action Conditions
// **********************************
  final public void parseDAGD(UngroundDurativeAction da, Map varMap) throws ParseException {
    if (jj_2_52(20)) {
      parseTimedGD(da, varMap);
    } else if (jj_2_53(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AND);
      label_13:
      while (true) {
        parseTimedGD(da, varMap);
        if (jj_2_51(20)) {
          ;
        } else {
          break label_13;
        }
      }
      jj_consume_token(CLOSE);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parseTimedGD(UngroundDurativeAction da, Map varMap) throws ParseException {
        Condition c;
    if (jj_2_54(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AT_START);
      c = parseGD(varMap, false);
      jj_consume_token(CLOSE);
                                                              ((AND) da.startCondition).add(c);
    } else if (jj_2_55(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AT_END);
      c = parseGD(varMap, false);
      jj_consume_token(CLOSE);
                                                            ((AND) da.endCondition).add(c);
    } else if (jj_2_56(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(OVER_ALL);
      c = parseGD(varMap, false);
      jj_consume_token(CLOSE);
                                                              ((AND) da.invariant).add(c);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// **********************************
// *	Parse Duration
// **********************************
  final public DurationConstraint parseDurationConstraint(UngroundDurativeAction da, Map varMap) throws ParseException {
        SimpleDurationConstraint sdc;
        DurationConstraint dc;
    if (jj_2_58(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AND);
                       dc = new DurationConstraint();
      label_14:
      while (true) {
        sdc = parseSimpleDurationConstraint(da, varMap);
                dc.add(sdc);
        if (jj_2_57(20)) {
          ;
        } else {
          break label_14;
        }
      }
      jj_consume_token(CLOSE);
                    {if (true) return dc;}
    } else if (jj_2_59(20)) {
      sdc = parseSimpleDurationConstraint(da, varMap);
                                                         {if (true) return sdc;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleDurationConstraint parseSimpleDurationConstraint(UngroundDurativeAction da, Map varMap) throws ParseException {
        int t;
        Function f;
    jj_consume_token(OPEN);
    t = parseDOp();
    jj_consume_token(DUR_VAR);
    f = parseFExp(varMap);
    jj_consume_token(CLOSE);
                SimpleDurationConstraint s = new SimpleDurationConstraint(da.duration, f, t);
                {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public int parseDOp() throws ParseException {
        Token t;
    if (jj_2_60(20)) {
      t = jj_consume_token(BINARY_COMP);
    } else if (jj_2_61(20)) {
      t = jj_consume_token(EQUALS);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                int i = MetricSymbolStore.getType(t.toString());
                if (i == MetricSymbolStore.LESS_THAN) i = MetricSymbolStore.LESS_THAN_EQUAL;
                else if (i == MetricSymbolStore.GREATER_THAN) i = MetricSymbolStore.GREATER_THAN_EQUAL;
                {if (true) return i;}
    throw new Error("Missing return statement in function");
  }

// **********************************
// *	Parse Durative Action Effects
// **********************************
  final public void parseDAEffect(UngroundDurativeAction da, Map varMap) throws ParseException {
    if (jj_2_63(20)) {
      parseTimedEffect(da, varMap);
    } else if (jj_2_64(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AND);
      label_15:
      while (true) {
        if (jj_2_62(20)) {
          ;
        } else {
          break label_15;
        }
        parseDAEffect(da, varMap);
      }
      jj_consume_token(CLOSE);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parseTimedEffect(UngroundDurativeAction da, Map varMap) throws ParseException {
        Effect e;
    if (jj_2_65(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AT_START);
      e = parseEffect(varMap);
      jj_consume_token(CLOSE);
                                                          ((AND)da.startEffect).add(e);
    } else if (jj_2_66(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AT_START);
      e = parseFAssignDA(da, varMap);
      jj_consume_token(CLOSE);
                                                                 ((AND)da.startEffect).add(e);
    } else if (jj_2_67(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AT_END);
      e = parseEffect(varMap);
      jj_consume_token(CLOSE);
                                                        ((AND)da.endEffect).add(e);
    } else if (jj_2_68(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(AT_END);
      e = parseFAssignDA(da, varMap);
      jj_consume_token(CLOSE);
                                                                ((AND)da.endEffect).add(e);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public ResourceOperator parseFAssignDA(UngroundDurativeAction da, Map varMap) throws ParseException {
        Token t1;
        NamedFunction f1;
        Function f2;
    jj_consume_token(OPEN);
    t1 = jj_consume_token(ASSIGN_OP);
    f1 = parseFHead(varMap);
    f2 = parseFExpDA(da,varMap);
    jj_consume_token(CLOSE);
                {if (true) return new ResourceOperator(t1.toString(), f1, f2);}
    throw new Error("Missing return statement in function");
  }

  final public Function parseFExpDA(UngroundDurativeAction da, Map varMap) throws ParseException {
        Token t1;
        Function f1, f2;
    if (jj_2_69(20)) {
      t1 = jj_consume_token(NUMBER);
                        {if (true) return new NumberFunction(Double.parseDouble(t1.toString()));}
    } else if (jj_2_70(20)) {
      jj_consume_token(OPEN);
      t1 = jj_consume_token(BINARY_OP);
      f1 = parseFExpDA(da, varMap);
      f2 = parseFExpDA(da, varMap);
      jj_consume_token(CLOSE);
                BinaryFunction bf = new BinaryFunction(t1.toString(), f1, f2);
                {if (true) return bf;}
    } else if (jj_2_71(20)) {
      jj_consume_token(OPEN);
      t1 = jj_consume_token(TYPE_IDENT);
      f1 = parseFExpDA(da, varMap);
      f2 = parseFExpDA(da, varMap);
      jj_consume_token(CLOSE);
                BinaryFunction bf = new BinaryFunction(t1.toString(), f1, f2);
                {if (true) return bf;}
    } else if (jj_2_72(20)) {
      jj_consume_token(OPEN);
      t1 = jj_consume_token(TYPE_IDENT);
      f1 = parseFExpDA(da, varMap);
      jj_consume_token(CLOSE);
                BinaryFunction bf = new BinaryFunction(t1.toString(), new NumberFunction(0), f1);
                {if (true) return bf;}
    } else if (jj_2_73(20)) {
      jj_consume_token(DUR_VAR);
                    {if (true) return da.duration;}
    } else if (jj_2_74(20)) {
      f1 = parseFExp(varMap);
                                 {if (true) return f1;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// ******************************************************************************
// *																			*
// * 							Parse the Problem File							*
// *																			*
// ******************************************************************************
  final public boolean parseProblem() throws ParseException {
    Token t, t2;
    jj_consume_token(OPEN);
    jj_consume_token(DEFINE);
    jj_consume_token(OPEN);
    jj_consume_token(PROBLEM);
    t = jj_consume_token(NAME);
    jj_consume_token(CLOSE);
    jj_consume_token(OPEN);
    jj_consume_token(DOMAIN_LABEL);
    t2 = jj_consume_token(NAME);
    jj_consume_token(CLOSE);
                UP.ProblemName = t.toString();
                UP.ProblemDomainName = t2.toString();
                if (!UP.DomainName.toLowerCase().equals(t2.toString().toLowerCase()))
                        JavaFF.parsingOutput.println("Warning Domain Name and Problem Name do not match");
    if (jj_2_75(20)) {
      parseRequireDef();
    } else {
      ;
    }
    if (jj_2_76(20)) {
      parseObjectDeclaration();
    } else {
      ;
    }
    parseInit();
    parseGoal();
    if (jj_2_77(20)) {
      parseMetric();
    } else {
      ;
    }
    jj_consume_token(CLOSE);
    jj_consume_token(0);
      {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

// ***************************************************
// *	Parse the objects
// ***************************************************
  final public void parseObjectDeclaration() throws ParseException {
    TypedList tl;
    jj_consume_token(OPEN);
    jj_consume_token(OBJECTS);
    tl = parseTypedList();
    jj_consume_token(CLOSE);
                Iterator it = tl.objects.iterator();
                while (it.hasNext())
                {
                        String str = (String) it.next();
                        PDDLObject o = new PDDLObject(str, (Type) tl.types.get(str));
                        UP.objects.add(o);
                        UP.objectMap.put(str, o);
                }
  }

// ***************************************************
// *	Parse the Initial State
// ***************************************************
  final public void parseInit() throws ParseException {
    jj_consume_token(OPEN);
    jj_consume_token(INIT);
    label_16:
    while (true) {
      parseInitEl();
      if (jj_2_78(20)) {
        ;
      } else {
        break label_16;
      }
    }
    jj_consume_token(CLOSE);
  }

  final public void parseInitEl() throws ParseException {
    Literal pp;
        NamedFunction nf;
        Token t1;
    if (jj_2_79(20)) {
      pp = parseLiteralName();
                             UP.initial.add(pp);
    } else if (jj_2_80(20)) {
      jj_consume_token(OPEN);
      jj_consume_token(EQUALS);
      nf = parseFHead(null);
      t1 = jj_consume_token(NUMBER);
      jj_consume_token(CLOSE);
                UP.funcValues.put(nf, new BigDecimal(Double.parseDouble(t1.toString())));
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Literal parseLiteralName() throws ParseException {
    Literal pp;
    pp = parseAtomicFormula(UP.objectMap, true);
                                                 {if (true) return pp;}
    throw new Error("Missing return statement in function");
  }

// **********************************
// *	Parse Goal
// **********************************
  final public void parseGoal() throws ParseException {
        Condition e;
    jj_consume_token(OPEN);
    jj_consume_token(GOAL);
    e = parseGD(UP.objectMap, true);
    jj_consume_token(CLOSE);
          UP.goal = (GroundCondition) e;
  }

// **********************************
// *	Parse Metric
// **********************************
  final public void parseMetric() throws ParseException {
        int type;
        Function f1;
    jj_consume_token(OPEN);
    jj_consume_token(METRIC);
    type = parseOptimization();
    f1 = parseFExp(UP.objectMap);
    jj_consume_token(CLOSE);
                UP.metric = new Metric(type, f1);
  }

  final public int parseOptimization() throws ParseException {
        Token t1;
    t1 = jj_consume_token(OPTIMIZATION);
                if (t1.toString().equals("minimize")) {if (true) return Metric.MINIMIZE;}
                else if (t1.toString().equals("maximize")) {if (true) return Metric.MAXIMIZE;}
                else {if (true) return -1;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3_80()) return true;
    }
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AND)) return true;
    Token xsp;
    if (jj_3_51()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) return true;
    }
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_32()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(DURATION)) return true;
    if (jj_3R_58()) return true;
    if (jj_scan_token(CONDITION)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(EFFECT)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(CONSTANTS)) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_33()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_3R_34()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3_36()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(OBJECTS)) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) return true;
    }
    return false;
  }

  final private boolean jj_3R_50() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_19()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(DURATIVE_ACTION)) return true;
    if (jj_3R_52()) return true;
    if (jj_scan_token(PARAMETERS)) return true;
    if (jj_scan_token(OPEN)) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(NON_HANDLED_LABELS)) return true;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) return true;
    }
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_22() {
    Token xsp;
    if (jj_3_18()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_18()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(TYPE_IDENT)) return true;
    if (jj_3R_23()) return true;
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    }
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(ASSIGN_OP)) return true;
    if (jj_3R_38()) return true;
    if (jj_3R_37()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_3R_51()) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(EITHER)) return true;
    Token xsp;
    if (jj_3_15()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_33()) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_28()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(OPEN)) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3_32()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_scan_token(DUR_VAR)) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    if (jj_scan_token(TOTAL_TIME)) return true;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(TYPE_IDENT)) return true;
    if (jj_3R_45()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(TYPE_IDENT)) return true;
    if (jj_3R_45()) return true;
    if (jj_3R_45()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(BINARY_OP)) return true;
    if (jj_3R_45()) return true;
    if (jj_3R_45()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_3R_39()) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_scan_token(EFFECT)) return true;
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_scan_token(PRECONDITION)) return true;
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) return true;
    }
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(ASSIGN_OP)) return true;
    if (jj_3R_38()) return true;
    if (jj_3R_45()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(TYPE_IDENT)) return true;
    if (jj_3R_37()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(TYPE_IDENT)) return true;
    if (jj_3R_37()) return true;
    if (jj_3R_37()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(REQUIREMENT_LABELS)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) return true;
    }
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AT_END)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AT_END)) return true;
    if (jj_3R_31()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AT_START)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(BINARY_OP)) return true;
    if (jj_3R_37()) return true;
    if (jj_3R_37()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AT_START)) return true;
    if (jj_3R_31()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    Token xsp;
    if (jj_3_11()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_11()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(TYPE_IDENT)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_scan_token(EQUALS)) return true;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_62()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) return true;
    }
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(ACTION)) return true;
    if (jj_3R_52()) return true;
    if (jj_scan_token(PARAMETERS)) return true;
    if (jj_scan_token(OPEN)) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(TYPES)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_10()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_12()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(BINARY_COMP)) return true;
    if (jj_3R_37()) return true;
    if (jj_3R_37()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) return true;
    }
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(REQUIREMENTS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_7()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(OPTIMIZATION)) return true;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_scan_token(BINARY_COMP)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) return true;
    }
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(METRIC)) return true;
    if (jj_3R_57()) return true;
    if (jj_3R_37()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_3R_56()) return true;
    if (jj_scan_token(DUR_VAR)) return true;
    if (jj_3R_37()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) return true;
    }
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AND)) return true;
    Token xsp;
    if (jj_3_57()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_57()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_3R_39()) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_3R_51()) return true;
    if (jj_3R_26()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(OVER_ALL)) return true;
    if (jj_3R_30()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AT_END)) return true;
    if (jj_3R_30()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(FUNCTIONS)) return true;
    Token xsp;
    if (jj_3_40()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_40()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(AT_START)) return true;
    if (jj_3R_30()) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_34()) return true;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(EQUALS)) return true;
    if (jj_3R_38()) return true;
    if (jj_scan_token(NUMBER)) return true;
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(OPEN)) return true;
    if (jj_scan_token(PREDICATES)) return true;
    Token xsp;
    if (jj_3_23()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_23()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  public PDDL21parserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[80];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public PDDL21parser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PDDL21parserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PDDL21parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PDDL21parserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PDDL21parser(PDDL21parserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(PDDL21parserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[54];
    for (int i = 0; i < 54; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 54; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 80; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
