/*
 * Decompiled with CFR 0.152.
 */
package com.github.tototoshi.csv;

import com.github.tototoshi.csv.LineReader;
import java.io.IOException;
import scala.io.Source;

public class SourceLineReader
implements LineReader {
    private Source source;

    public SourceLineReader(Source source) {
        this.source = source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String readLineWithTerminator() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (!this.source.hasNext()) {
                if (stringBuilder.length() != 0) return stringBuilder.toString();
                return null;
            }
            char c = this.source.next();
            stringBuilder.append(c);
            if (c == '\n' || c == '\u2028' || c == '\u2029' || c == '\u0085') return stringBuilder.toString();
            if (c != '\r') continue;
            if (!this.source.hasNext()) return stringBuilder.toString();
            c = this.source.next();
            stringBuilder.append((int)c);
            if (c == '\n') return stringBuilder.toString();
        }
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

